/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.utils;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.linux.CpuUsageGaugeSet;
import com.alibaba.csp.ahas.shaded.org.slf4j.Logger;
import com.alibaba.csp.ahas.shaded.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import org.hyperic.sigar.Sigar;

public class SystemInfoUtils {
    private static final Logger logger = LoggerFactory.getLogger(CpuUsageGaugeSet.class);
    public static String MAC_FILE_NAME = "libsigar-universal64-macosx.dylib";
    public static String WINDOWS_FILE_NAME = "sigar-amd64-winnt.dll";
    public static Sigar sigar = null;

    public static void init() {
        if (SystemInfoUtils.needLoad()) {
            try {
                SystemInfoUtils.loadLib();
                sigar = new Sigar();
            }
            catch (Throwable e) {
                logger.error("Load dll error!", e);
            }
        }
    }

    public static boolean needLoad() {
        String osArch;
        boolean os = false;
        boolean arch = false;
        String osName = System.getProperty("os.name");
        if (osName != null && (osName.contains("Windows") || osName.contains("Mac"))) {
            os = true;
        }
        if ((osArch = System.getProperty("os.arch")) != null) {
            arch = osArch.contains("64");
        }
        return os & arch;
    }

    public static void loadLib() throws IOException {
        File file;
        String osName = System.getProperty("os.name");
        String resource = "/";
        if (osName.contains("Windows")) {
            resource = resource + WINDOWS_FILE_NAME;
        } else if (osName.contains("Mac")) {
            resource = resource + MAC_FILE_NAME;
        }
        InputStream input = SystemInfoUtils.class.getResourceAsStream(resource);
        URL res = SystemInfoUtils.class.getResource(resource);
        String path = res.getPath();
        if (path.indexOf("!") > 0) {
            path = path.substring(0, path.substring(0, path.indexOf("!")).lastIndexOf("/")) + resource;
        }
        if (path.indexOf(":") > 0 && !osName.contains("Windows")) {
            path = path.substring(path.indexOf(":") + 1);
        }
        if (!(file = new File(path)).exists()) {
            int read;
            file.createNewFile();
            FileOutputStream out = new FileOutputStream(file);
            byte[] bytes = new byte[8192];
            while ((read = input.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read);
            }
            out.flush();
            ((OutputStream)out).close();
        }
        if (file != null) {
            System.setProperty("org.hyperic.sigar.path", file.getParent());
            System.load(file.getPath());
        }
    }

    public static void addLibraryDir(String libraryPath) throws IOException {
        try {
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            String[] paths = (String[])field.get(null);
            for (int i = 0; i < paths.length; ++i) {
                if (!libraryPath.equals(paths[i])) continue;
                return;
            }
            String[] tmp = new String[paths.length + 1];
            System.arraycopy(paths, 0, tmp, 0, paths.length);
            tmp[paths.length] = libraryPath;
            field.set(null, tmp);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Failedto get permissions to set library path");
        }
        catch (NoSuchFieldException e) {
            throw new IOException("Failedto get field handle to set library path");
        }
    }

    public static void main(String[] args) {
        SystemInfoUtils.init();
        System.out.println(System.getProperty("java.library.path"));
        System.out.println(sigar);
    }
}

