/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.windows;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CachedMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.PersistentGauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.utils.FormatUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.utils.SystemInfoUtils;
import com.alibaba.csp.ahas.shaded.org.slf4j.Logger;
import com.alibaba.csp.ahas.shaded.org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hyperic.sigar.Cpu;
import org.hyperic.sigar.SigarException;

public class CpuUsageGaugeSet
extends CachedMetricSet {
    private static final Logger logger = LoggerFactory.getLogger(CpuUsageGaugeSet.class);
    private float[] cpuUsage;
    private CpuInfo lastCollectedCpuInfo;
    private long processRunning;
    private long processBlocked;
    private long totalInterrupts;
    private double interruptsRate;
    private long totalContextSwitches;
    private double contextSwitchesRate;
    private Map<MetricName, Metric> gauges = new HashMap<MetricName, Metric>();

    public CpuUsageGaugeSet(long dataTTL, TimeUnit unit, Clock clock) {
        super(dataTTL, unit, clock);
        this.cpuUsage = new float[CpuUsage.values().length];
        this.lastCollectedCpuInfo = new CpuInfo();
        this.populateMetrics();
    }

    public CpuUsageGaugeSet(long dataTTL, TimeUnit unit) {
        this(dataTTL, unit, Clock.defaultClock());
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        return this.gauges;
    }

    private float getUsage(long current, long last, CpuInfo curInfo, CpuInfo lastInfo) {
        try {
            float f = 100.0f * (float)(current - last) / (float)(curInfo.totalTime - lastInfo.totalTime);
            return FormatUtils.formatFloat(f);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    private CpuInfo collectCpuInfo() {
        Cpu cpu = null;
        try {
            cpu = SystemInfoUtils.sigar.getCpu();
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
        if (cpu == null) {
            return new CpuInfo();
        }
        CpuInfo info = new CpuInfo();
        info.userTime = cpu.getUser();
        info.niceTime = cpu.getNice();
        info.systemTime = cpu.getSys();
        info.idleTime = cpu.getIdle();
        info.iowaitTime = cpu.getWait();
        info.irqTime = cpu.getIrq();
        info.softirqTime = cpu.getSoftIrq();
        info.stealTime = cpu.getStolen();
        info.totalTime = cpu.getTotal();
        return info;
    }

    @Override
    protected void getValueInternal() {
        CpuInfo current = this.collectCpuInfo();
        this.cpuUsage[CpuUsage.USER.ordinal()] = this.getUsage(current.userTime, this.lastCollectedCpuInfo.userTime, current, this.lastCollectedCpuInfo);
        this.cpuUsage[CpuUsage.NICE.ordinal()] = this.getUsage(current.niceTime, this.lastCollectedCpuInfo.niceTime, current, this.lastCollectedCpuInfo);
        this.cpuUsage[CpuUsage.SYSTEM.ordinal()] = this.getUsage(current.systemTime, this.lastCollectedCpuInfo.systemTime, current, this.lastCollectedCpuInfo);
        this.cpuUsage[CpuUsage.IDLE.ordinal()] = this.getUsage(current.idleTime, this.lastCollectedCpuInfo.idleTime, current, this.lastCollectedCpuInfo);
        this.cpuUsage[CpuUsage.IOWAIT.ordinal()] = this.getUsage(current.iowaitTime, this.lastCollectedCpuInfo.iowaitTime, current, this.lastCollectedCpuInfo);
        this.cpuUsage[CpuUsage.IRQ.ordinal()] = this.getUsage(current.irqTime, this.lastCollectedCpuInfo.irqTime, current, this.lastCollectedCpuInfo);
        this.cpuUsage[CpuUsage.SOFTIRQ.ordinal()] = this.getUsage(current.softirqTime, this.lastCollectedCpuInfo.softirqTime, current, this.lastCollectedCpuInfo);
        this.cpuUsage[CpuUsage.STEAL.ordinal()] = this.getUsage(current.stealTime, this.lastCollectedCpuInfo.stealTime, current, this.lastCollectedCpuInfo);
        this.cpuUsage[CpuUsage.GUEST.ordinal()] = this.getUsage(current.guestTIme, this.lastCollectedCpuInfo.guestTIme, current, this.lastCollectedCpuInfo);
        this.lastCollectedCpuInfo = current;
    }

    private void populateMetrics() {
        this.gauges.put(MetricName.build("cpu.user"), new CpuGauge(CpuUsage.USER.ordinal()));
        this.gauges.put(MetricName.build("cpu.nice"), new CpuGauge(CpuUsage.NICE.ordinal()));
        this.gauges.put(MetricName.build("cpu.system"), new CpuGauge(CpuUsage.SYSTEM.ordinal()));
        this.gauges.put(MetricName.build("cpu.idle"), new CpuGauge(CpuUsage.IDLE.ordinal()));
        this.gauges.put(MetricName.build("cpu.iowait"), new CpuGauge(CpuUsage.IOWAIT.ordinal()));
        this.gauges.put(MetricName.build("cpu.irq"), new CpuGauge(CpuUsage.IRQ.ordinal()));
        this.gauges.put(MetricName.build("cpu.softirq"), new CpuGauge(CpuUsage.SOFTIRQ.ordinal()));
        this.gauges.put(MetricName.build("cpu.steal"), new CpuGauge(CpuUsage.STEAL.ordinal()));
        this.gauges.put(MetricName.build("cpu.guest"), new CpuGauge(CpuUsage.GUEST.ordinal()));
        this.gauges.put(MetricName.build("interrupts"), new PersistentGauge<Double>(){

            @Override
            public Double getValue() {
                CpuUsageGaugeSet.this.refreshIfNecessary();
                return CpuUsageGaugeSet.this.interruptsRate;
            }
        });
        this.gauges.put(MetricName.build("context_switches"), new PersistentGauge<Double>(){

            @Override
            public Double getValue() {
                CpuUsageGaugeSet.this.refreshIfNecessary();
                return CpuUsageGaugeSet.this.contextSwitchesRate;
            }
        });
        this.gauges.put(MetricName.build("process.running"), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                CpuUsageGaugeSet.this.refreshIfNecessary();
                return CpuUsageGaugeSet.this.processRunning;
            }
        });
        this.gauges.put(MetricName.build("process.blocked"), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                CpuUsageGaugeSet.this.refreshIfNecessary();
                return CpuUsageGaugeSet.this.processBlocked;
            }
        });
    }

    private class CpuInfo {
        long userTime;
        long niceTime;
        long systemTime;
        long idleTime;
        long iowaitTime;
        long irqTime;
        long softirqTime;
        long stealTime;
        long guestTIme;
        long totalTime;

        private CpuInfo() {
        }
    }

    private class CpuGauge
    extends PersistentGauge<Float> {
        private int index;

        public CpuGauge(int index) {
            this.index = index;
        }

        @Override
        public Float getValue() {
            try {
                CpuUsageGaugeSet.this.refreshIfNecessary();
                return Float.valueOf(CpuUsageGaugeSet.this.cpuUsage[this.index]);
            }
            catch (Exception e) {
                return Float.valueOf(0.0f);
            }
        }
    }

    private static enum CpuUsage {
        USER,
        NICE,
        SYSTEM,
        IDLE,
        IOWAIT,
        IRQ,
        SOFTIRQ,
        STEAL,
        GUEST;

    }
}

