/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.windows;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CachedMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.PersistentGauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.utils.SystemInfoUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SystemLoadGaugeSet
extends CachedMetricSet {
    private Map<MetricName, Metric> gauges;
    private float[] loadAvg = new float[LoadAvg.values().length];

    public SystemLoadGaugeSet() {
        this(DEFAULT_DATA_TTL, TimeUnit.MILLISECONDS);
    }

    public SystemLoadGaugeSet(long dataTTL, TimeUnit unit) {
        super(dataTTL, unit);
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        HashMap<MetricName, Metric> gauges = new HashMap<MetricName, Metric>();
        gauges.put(MetricName.build("load.1min"), new PersistentGauge<Float>(){

            @Override
            public Float getValue() {
                SystemLoadGaugeSet.this.refreshIfNecessary();
                return Float.valueOf(SystemLoadGaugeSet.this.loadAvg[LoadAvg.ONE_MIN.ordinal()]);
            }
        });
        gauges.put(MetricName.build("load.5min"), new PersistentGauge<Float>(){

            @Override
            public Float getValue() {
                SystemLoadGaugeSet.this.refreshIfNecessary();
                return Float.valueOf(SystemLoadGaugeSet.this.loadAvg[LoadAvg.FIVE_MIN.ordinal()]);
            }
        });
        gauges.put(MetricName.build("load.15min"), new PersistentGauge<Float>(){

            @Override
            public Float getValue() {
                SystemLoadGaugeSet.this.refreshIfNecessary();
                return Float.valueOf(SystemLoadGaugeSet.this.loadAvg[LoadAvg.FIFTEEN_MIN.ordinal()]);
            }
        });
        return gauges;
    }

    @Override
    protected void getValueInternal() {
        double[] load = null;
        try {
            load = SystemInfoUtils.sigar.getLoadAverage();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (load == null) {
            return;
        }
        if (load.length > 0) {
            this.loadAvg[LoadAvg.ONE_MIN.ordinal()] = (float)load[0];
        }
        if (load.length > 1) {
            this.loadAvg[LoadAvg.FIVE_MIN.ordinal()] = (float)load[1];
        }
        if (load.length > 2) {
            this.loadAvg[LoadAvg.FIFTEEN_MIN.ordinal()] = (float)load[2];
        }
    }

    private static enum LoadAvg {
        ONE_MIN,
        FIVE_MIN,
        FIFTEEN_MIN;

    }
}

