/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.ClusterHistogram;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Compass;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Counter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.FastCompass;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Gauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Histogram;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.IMetricManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Meter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Timer;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.config.MetricsCollectPeriodConfig;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.filter.CompositeMetricFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.filter.TimeMetricLevelFilter;
import com.alibaba.csp.ahas.shaded.org.slf4j.Logger;
import com.alibaba.csp.ahas.shaded.org.slf4j.LoggerFactory;
import java.io.Closeable;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MetricManagerReporter
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(MetricManagerReporter.class);
    private static final AtomicInteger FACTORY_ID = new AtomicInteger();
    protected final double durationFactor;
    protected final double rateFactor;
    private final IMetricManager metricManager;
    private final ScheduledExecutorService executor;
    private final String durationUnit;
    private final String rateUnit;
    private long schedulePeriod = 1L;
    private TimeUnit scheduleUnit = TimeUnit.SECONDS;
    private TimeMetricLevelFilter timeMetricLevelFilter;
    private CompositeMetricFilter compositeMetricFilter;
    private ScheduledFuture futureTask;
    private Runnable task = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!MetricManagerReporter.this.runFlag) {
                return;
            }
            try {
                MetricManagerReporter.this.timeMetricLevelFilter.beforeReport();
                MetricManagerReporter.this.report();
            }
            catch (Throwable ex) {
                LOG.error("Throwable RuntimeException thrown from {}#report. Exception was suppressed.", (Object)MetricManagerReporter.this.getClass().getSimpleName(), (Object)ex);
            }
            finally {
                MetricManagerReporter.this.timeMetricLevelFilter.afterReport();
            }
        }
    };
    private volatile boolean runFlag = true;

    protected MetricManagerReporter(IMetricManager metricManager, String name, MetricFilter filter, MetricsCollectPeriodConfig metricsReportPeriodConfig, TimeUnit rateUnit, TimeUnit durationUnit) {
        this(metricManager, filter, new TimeMetricLevelFilter(metricsReportPeriodConfig), rateUnit, durationUnit, Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory(name + '-' + FACTORY_ID.incrementAndGet())));
    }

    protected MetricManagerReporter(IMetricManager metricManager, String name, MetricFilter filter, TimeMetricLevelFilter timeMetricLevelFilter, TimeUnit rateUnit, TimeUnit durationUnit) {
        this(metricManager, filter, timeMetricLevelFilter, rateUnit, durationUnit, Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory(name + '-' + FACTORY_ID.incrementAndGet())));
    }

    protected MetricManagerReporter(IMetricManager metricManager, MetricFilter filter, TimeMetricLevelFilter timeMetricLevelFilter, TimeUnit rateUnit, TimeUnit durationUnit, ScheduledExecutorService executor) {
        this.metricManager = metricManager;
        this.executor = executor;
        this.rateFactor = rateUnit.toSeconds(1L);
        this.rateUnit = this.calculateRateUnit(rateUnit);
        this.durationFactor = 1.0 / (double)durationUnit.toNanos(1L);
        this.durationUnit = durationUnit.toString().toLowerCase(Locale.US);
        this.timeMetricLevelFilter = timeMetricLevelFilter;
        this.compositeMetricFilter = new CompositeMetricFilter(timeMetricLevelFilter, filter);
    }

    public void suspension() {
        this.runFlag = false;
    }

    public void resumption() {
        this.runFlag = true;
    }

    public void start(long period, TimeUnit unit) {
        this.schedulePeriod = period;
        this.scheduleUnit = unit;
        this.futureTask = this.executor.scheduleWithFixedDelay(this.task, this.schedulePeriod, this.schedulePeriod, this.scheduleUnit);
    }

    public void stop() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(this.schedulePeriod * 2L, this.scheduleUnit)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(this.schedulePeriod * 2L, this.scheduleUnit)) {
                    LOG.warn(this.getClass().getSimpleName() + ": ScheduledExecutorService did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void reschedule(long period, TimeUnit unit) {
        if (this.futureTask.cancel(false)) {
            this.schedulePeriod = period;
            this.scheduleUnit = unit;
            this.futureTask = this.executor.scheduleWithFixedDelay(this.task, period, period, unit);
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report() {
        MetricManagerReporter metricManagerReporter = this;
        synchronized (metricManagerReporter) {
            Map<Class<? extends Metric>, Map<MetricName, ? extends Metric>> categoryMetrics = this.metricManager.getAllCategoryMetrics(this.compositeMetricFilter);
            this.report(categoryMetrics.get(Gauge.class), categoryMetrics.get(Counter.class), categoryMetrics.get(Histogram.class), categoryMetrics.get(Meter.class), categoryMetrics.get(Timer.class), categoryMetrics.get(Compass.class), categoryMetrics.get(FastCompass.class), categoryMetrics.get(ClusterHistogram.class));
        }
    }

    public abstract void report(Map<MetricName, Gauge> var1, Map<MetricName, Counter> var2, Map<MetricName, Histogram> var3, Map<MetricName, Meter> var4, Map<MetricName, Timer> var5, Map<MetricName, Compass> var6, Map<MetricName, FastCompass> var7, Map<MetricName, ClusterHistogram> var8);

    protected String getRateUnit() {
        return this.rateUnit;
    }

    protected String getDurationUnit() {
        return this.durationUnit;
    }

    protected double convertDuration(double duration) {
        return duration * this.durationFactor;
    }

    protected double convertRate(double rate) {
        return rate * this.rateFactor;
    }

    private String calculateRateUnit(TimeUnit unit) {
        String s = unit.toString().toLowerCase(Locale.US);
        return s.substring(0, s.length() - 1);
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        private NamedThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "metrics-" + name + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

