/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin;

import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.StringUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.AbstractFileBackend;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.ChannelFileBackend;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.DataSource;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.status.LogDescriptionRegister;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.utils.FileUtil;
import com.alibaba.csp.ahas.shaded.org.slf4j.Logger;
import com.alibaba.csp.ahas.shaded.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class DataSourceFile {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceFile.class);
    private AbstractFileBackend backend;
    private MetricLevel level;
    private int currentOffset;
    private int currentOrder;
    private String path;

    public DataSourceFile(String path, MetricLevel level) {
        this.path = path;
        this.level = level;
    }

    public void init() throws IOException {
        this.init(false);
    }

    public void init(boolean readOnly) throws IOException {
        this.backend = new ChannelFileBackend(this.path, readOnly);
    }

    public void create() throws IOException {
        File dataSourceFile = new File(this.path);
        dataSourceFile.createNewFile();
        this.init();
    }

    public void read(LogDescriptionRegister register) throws IOException {
        logger.info("Read datasource file {}...", (Object)this.path);
        byte[] dataSourceBytes = this.backend.readAll();
        String[] dataSources = new String(dataSourceBytes).split("\n");
        if (dataSources == null || dataSources.length == 0) {
            return;
        }
        int maxOffset = 0;
        int maxOrder = 0;
        int dataSourceNum = 0;
        for (String s : dataSources) {
            try {
                if (StringUtils.isBlank(s)) continue;
                DataSource dataSource = null;
                try {
                    dataSource = JSON.parseObject(s, DataSource.class);
                }
                catch (Exception e) {
                    logger.error("Error datasource json {} !", (Object)s, (Object)e);
                }
                if (dataSource == null) continue;
                dataSource.addMetricObject();
                if (dataSource.getOrder() > maxOrder) {
                    maxOrder = dataSource.getOrder();
                }
                if (dataSource.getOffset() >= maxOffset) {
                    maxOffset = dataSource.getOffset();
                }
                ++dataSourceNum;
                register.addDataSources(dataSource.getMetricObject(), dataSource);
            }
            catch (Exception e) {
                logger.error("Error file path {}, !", (Object)this.path, (Object)e);
            }
        }
        if (dataSourceNum > 0) {
            this.currentOffset = maxOffset + 8;
            this.currentOrder = maxOrder + 1;
        }
    }

    public void write(long metricsTime, byte[] dataSourceBlock, Map<MetricObject, DataSource> dataSourceObjects, int length, int lastBlockLength) throws IOException {
        long position = this.backend.getLength();
        if (FileUtil.checkFileSize(position + (long)length)) {
            this.backend.write(position, dataSourceBlock, 0, length);
        } else {
            logger.error("Exceeded file size {}, path: {}", (Object)0x40000000L, (Object)this.path);
        }
    }

    public int getCurrentOffset() {
        return this.currentOffset;
    }

    public void setCurrentOffset(int currentOffset) {
        this.currentOffset = currentOffset;
    }

    public int getCurrentOrder() {
        return this.currentOrder;
    }

    public void setCurrentOrder(int currentOrder) {
        this.currentOrder = currentOrder;
    }

    public String getPath() {
        return this.path;
    }

    public MetricLevel getLevel() {
        return this.level;
    }

    public long getPosition() {
        return this.backend.getLength();
    }

    public void close() throws IOException {
        this.backend.sync();
        this.backend.close();
    }
}

