/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.StringUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.bean.MetricSearch;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.DataSource;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.IndexData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class LogStatusManager {
    private volatile boolean enable = false;
    private Map<MetricLevel, NavigableMap<Long, IndexData>> indexData = new HashMap<MetricLevel, NavigableMap<Long, IndexData>>();
    private Map<MetricObject, DataSource> dataSources = new HashMap<MetricObject, DataSource>();
    private Map<MetricLevel, Long> lastCollectionTime = new HashMap<MetricLevel, Long>(){
        {
            this.put(MetricLevel.CRITICAL, 0L);
            this.put(MetricLevel.MAJOR, 0L);
            this.put(MetricLevel.MINOR, 0L);
            this.put(MetricLevel.NORMAL, 0L);
            this.put(MetricLevel.TRIVIAL, 0L);
        }
    };

    public void addIndex(final long timestamp, MetricLevel level, final long start, final long end) {
        SortedMap index = this.indexData.get((Object)level);
        if (index == null) {
            this.indexData.put(level, (NavigableMap<Long, IndexData>)new TreeMap<Long, IndexData>(){
                {
                    this.put(timestamp, new IndexData(start, end));
                }
            });
        } else {
            index.put(timestamp, new IndexData(start, end));
        }
    }

    public void addDataSources(MetricObject metricObject, DataSource dataSource) {
        this.dataSources.put(dataSource.getMetricObject(), dataSource);
    }

    public void addDataSources(Map<MetricObject, DataSource> dataSources) {
        this.dataSources.putAll(dataSources);
    }

    public DataSource getDataSource(MetricObject metricObject) {
        return this.dataSources.get(metricObject);
    }

    public Map<MetricLevel, Set<DataSource>> search(List<MetricSearch> metricNames) {
        if (metricNames == null || metricNames.size() == 0) {
            return null;
        }
        HashMap<MetricLevel, Set<DataSource>> result = new HashMap<MetricLevel, Set<DataSource>>();
        for (MetricSearch simpleMetric : metricNames) {
            String key = simpleMetric.getKey();
            Map<String, String> tags = simpleMetric.getTags();
            for (Map.Entry<MetricObject, DataSource> entry0 : this.dataSources.entrySet()) {
                DataSource dataSource = entry0.getValue();
                String metricObjectName = dataSource.getMetricName();
                boolean keysEqual = true;
                boolean tagsEqual = true;
                if (!StringUtils.equals(key, metricObjectName)) {
                    keysEqual = false;
                    continue;
                }
                if (tags != null && tags.size() > 0) {
                    Map<String, String> dataSourceTag = dataSource.getTags();
                    if (dataSourceTag == null || dataSourceTag.size() == 0) {
                        tagsEqual = false;
                    } else {
                        for (Map.Entry<String, String> entry : tags.entrySet()) {
                            String entryKey = entry.getKey();
                            String entryValue = entry.getValue();
                            if (dataSourceTag.containsKey(entryKey)) {
                                if ("*".equals(entryValue) || entryValue == null) continue;
                                String[] metricTagValues = entryValue.split("\\|");
                                String dataSourceValue = dataSourceTag.get(entryKey);
                                boolean orMatch = false;
                                for (String tag : metricTagValues) {
                                    if (!StringUtils.equals(tag, dataSourceValue)) continue;
                                    orMatch = true;
                                    break;
                                }
                                if (orMatch) continue;
                                tagsEqual = false;
                                continue;
                            }
                            tagsEqual = false;
                            break;
                        }
                    }
                }
                if (!keysEqual || !tagsEqual) continue;
                this.addSearchResult(dataSource, result);
            }
        }
        return result;
    }

    private void addSearchResult(DataSource dataSource, Map<MetricLevel, Set<DataSource>> result) {
        MetricLevel level = dataSource.getLevel();
        Set<DataSource> dataSourceSet = result.get((Object)level);
        if (dataSourceSet == null) {
            dataSourceSet = result.put(level, new HashSet());
            dataSourceSet = result.get((Object)level);
        }
        dataSourceSet.add(dataSource);
    }

    public SortedMap<Long, IndexData> searchIndex(long start, long end, MetricLevel level) {
        NavigableMap<Long, IndexData> indexMap = this.indexData.get((Object)level);
        if (indexMap == null || indexMap.size() == 0) {
            return null;
        }
        NavigableMap<Long, IndexData> indexResult = indexMap.subMap(start, true, end, true);
        return indexResult;
    }

    public void clear() {
        this.indexData = new HashMap<MetricLevel, NavigableMap<Long, IndexData>>();
        this.dataSources = new HashMap<MetricObject, DataSource>();
    }

    public int getDataSourceNum() {
        return this.dataSources.size();
    }

    public long getLastCollectionTime(MetricLevel level) {
        return this.lastCollectionTime.get((Object)level);
    }

    public void setLastCollectionTime(MetricLevel level, long lastCollectionTime) {
        this.lastCollectionTime.put(level, lastCollectionTime);
    }
}

