/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.RandomAccessFileBackend;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import sun.nio.ch.DirectBuffer;

public class MmapFileBackend
extends RandomAccessFileBackend {
    private MappedByteBuffer byteBuffer;
    private int size;

    protected MmapFileBackend(String path, boolean readOnly, int length) throws IOException {
        super(path, readOnly);
        this.size = (int)this.getLength();
    }

    @Override
    public void init() throws IOException {
        try {
            this.mapFile(this.size);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
    }

    protected MmapFileBackend(String path, boolean readOnly) throws IOException {
        super(path, readOnly);
    }

    public void mapFile() throws IOException {
        int length = (int)this.getLength();
        this.mapFile(length);
    }

    public void mapFile(int length) throws IOException {
        if (length > 0) {
            FileChannel.MapMode mapMode = this.readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            this.byteBuffer = this.randomAccessFile.getChannel().map(mapMode, 0L, length);
        }
    }

    private void unmapFile() {
        if (this.byteBuffer != null) {
            if (this.byteBuffer instanceof DirectBuffer) {
                ((DirectBuffer)((Object)this.byteBuffer)).cleaner().clean();
            }
            this.byteBuffer = null;
        }
    }

    @Override
    public synchronized void sync() {
        if (this.byteBuffer != null) {
            this.byteBuffer.force();
        }
    }

    @Override
    public synchronized void write(long offset, byte[] b, int bytesStart, int length) throws IOException {
        if (this.byteBuffer == null) {
            throw new IOException("Write failed, file " + this.getPath() + " not mapped for I/O");
        }
        this.byteBuffer.position((int)offset);
        this.byteBuffer.put(b, bytesStart, length);
    }

    @Override
    public synchronized void read(long offset, byte[] b) throws IOException {
        if (this.byteBuffer == null) {
            throw new IOException("Read failed, file " + this.getPath() + " not mapped for I/O");
        }
        this.byteBuffer.position((int)offset);
        this.byteBuffer.get(b);
    }

    @Override
    public synchronized void setLength(long newLength) throws IOException {
        this.unmapFile();
        super.setLength(newLength);
        this.mapFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        try {
            if (!this.readOnly) {
                this.sync();
            }
            this.unmapFile();
        }
        finally {
            super.close();
        }
    }
}

