/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.AbstractFileBackend;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;
import java.nio.ByteBuffer;

public class RandomAccessFileBackend
extends AbstractFileBackend {
    protected final RandomAccessFile randomAccessFile;

    public RandomAccessFileBackend(String path, boolean readOnly) throws IOException {
        super(path, readOnly);
        this.randomAccessFile = new RandomAccessFile(path, readOnly ? "r" : "rw");
    }

    @Override
    public void init() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    @Override
    public synchronized void read(long offset, byte[] b) throws IOException {
        if (b == null) {
            return;
        }
        this.randomAccessFile.read(b, (int)offset, b.length);
    }

    @Override
    public synchronized void write(long offset, byte[] b, int bytesStart, int length) throws IOException {
        if (b == null) {
            return;
        }
        this.randomAccessFile.seek(offset);
        this.randomAccessFile.write(b, bytesStart, b.length);
    }

    @Override
    public synchronized void setLength(long length) throws IOException {
        if (length > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException("length above max integer");
        }
        this.randomAccessFile.setLength(length);
    }

    @Override
    public synchronized void sync() throws IOException {
        try {
            this.randomAccessFile.getFD().sync();
        }
        catch (SyncFailedException syncFailedException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void read(long offset, ByteBuffer b) throws IOException {
    }

    @Override
    public void write(long offset, ByteBuffer b) throws IOException {
    }
}

