/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.encodings;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.encodings.IntEncoder;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.encodings.LongEncoder;

public final class DeltaEncoding {

    public static class LongAscendDecoder
    extends LongEncoder {
        public LongAscendDecoder(long contextValue) {
            super(contextValue);
        }

        public LongAscendDecoder() {
            this(0L);
        }

        @Override
        public long encodeLong(long value) {
            if (value < 0L) {
                throw new IllegalArgumentException(String.format("input:%1$d must be greater than or equal zero", value));
            }
            return this.contextValue += value;
        }
    }

    public static class LongAscendEncoder
    extends LongEncoder {
        public LongAscendEncoder(long contextValue) {
            super(contextValue);
        }

        public LongAscendEncoder() {
            this(0L);
        }

        @Override
        public long encodeLong(long value) {
            long n = value - this.contextValue;
            if (n < 0L) {
                throw new IllegalArgumentException(String.format("input:%1$d must be greater than or equals %2$d", value, this.contextValue));
            }
            this.contextValue = value;
            return n;
        }
    }

    public static class IntAscendDecoder
    extends IntEncoder {
        public IntAscendDecoder(int contextValue) {
            super(contextValue);
        }

        public IntAscendDecoder() {
            this(0);
        }

        @Override
        public int encodeInt(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("input:%1$d must be greater than or equal zero", value));
            }
            return this.contextValue += value;
        }
    }

    public static class IntAscendEncoder
    extends IntEncoder {
        public IntAscendEncoder(int contextValue) {
            super(contextValue);
        }

        public IntAscendEncoder() {
            this(0);
        }

        @Override
        public int encodeInt(int value) {
            int n = value - this.contextValue;
            if (n < 0) {
                throw new IllegalArgumentException(String.format("input:%1$d must be greater than or equals %2$d", value, this.contextValue));
            }
            this.contextValue = value;
            return n;
        }
    }
}

