/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.IntOutputStream;

public class IntArrayOutputStream
extends IntOutputStream {
    private int[] array;
    private int writtenCount;

    public IntArrayOutputStream(int capacity) {
        this.array = new int[capacity];
        this.writtenCount = 0;
    }

    public IntArrayOutputStream() {
        this(512);
    }

    static int calcNewSize(int curr, int ext, int max) {
        int required = curr + ext;
        if (required < 0) {
            throw new RuntimeException("Required length was minus");
        }
        if (required <= max) {
            return max;
        }
        int newSize = max;
        while (required > newSize) {
            if ((newSize *= 2) >= 0) continue;
            throw new RuntimeException("Buffer overflow");
        }
        return newSize;
    }

    private void extend(int len) {
        int newSize = IntArrayOutputStream.calcNewSize(this.writtenCount, len, this.array.length);
        if (newSize <= this.array.length) {
            return;
        }
        int[] newArray = new int[newSize];
        System.arraycopy(this.array, 0, newArray, 0, this.writtenCount);
        this.array = newArray;
    }

    @Override
    public void write(int n) {
        this.extend(1);
        this.array[this.writtenCount++] = n;
    }

    @Override
    public void write(int[] array, int offset, int length) {
        this.extend(length);
        System.arraycopy(array, offset, this.array, this.writtenCount, length);
        this.writtenCount += length;
    }

    public int count() {
        return this.writtenCount;
    }

    public int[] toIntArray() {
        if (this.array.length == this.writtenCount) {
            return this.array;
        }
        int[] newArray = new int[this.writtenCount];
        System.arraycopy(this.array, 0, newArray, 0, this.writtenCount);
        return newArray;
    }
}

