/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.LongOutputStream;

public class LongArrayOutputStream
extends LongOutputStream {
    private long[] array;
    private int writtenCount;

    public LongArrayOutputStream(int capacity) {
        this.array = new long[capacity];
        this.writtenCount = 0;
    }

    public LongArrayOutputStream() {
        this(512);
    }

    static int calcNewSize(int curr, int ext, int max) {
        int required = curr + ext;
        if (max == 0) {
            return max;
        }
        if (required < 0) {
            throw new RuntimeException("Required length was minus");
        }
        if (required <= max) {
            return max;
        }
        int newSize = max;
        while (required > newSize) {
            if ((newSize *= 2) >= 0) continue;
            throw new RuntimeException("Buffer overflow");
        }
        return newSize;
    }

    private void extend(int len) {
        int newSize = LongArrayOutputStream.calcNewSize(this.writtenCount, len, this.array.length);
        if (newSize <= this.array.length) {
            return;
        }
        long[] newArray = new long[newSize];
        System.arraycopy(this.array, 0, newArray, 0, this.writtenCount);
        this.array = newArray;
    }

    @Override
    public void write(long n) {
        this.extend(1);
        this.array[this.writtenCount++] = n;
    }

    @Override
    public void write(long[] array, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.extend(length);
        System.arraycopy(array, offset, this.array, this.writtenCount, length);
        this.writtenCount += length;
    }

    public int count() {
        return this.writtenCount;
    }

    public long[] toLongArray() {
        if (this.array.length == this.writtenCount) {
            return this.array;
        }
        long[] newArray = new long[this.writtenCount];
        System.arraycopy(this.array, 0, newArray, 0, this.writtenCount);
        return newArray;
    }
}

