/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.LongFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.LongFilterFactory;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.LongBlockedInputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.LongBufferOutputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.LongOutputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.packers.LongBitPacking;
import java.nio.BufferUnderflowException;
import java.nio.LongBuffer;

public class LongDecompressStream
extends LongBlockedInputStream {
    private final LongBuffer source;
    private final LongFilter filter;
    private final LongBitPacking packer;
    private final int chunkSize;
    private int availableLen = 0;

    public LongDecompressStream(LongBuffer source, LongFilterFactory factory, LongBitPacking packer) {
        super(packer.getBlockSize());
        this.source = source;
        int outLen = this.source.remaining();
        if (outLen == 0) {
            this.filter = factory.newFilter(0L);
        } else {
            this.availableLen = (int)this.source.get() - 1;
            long first = this.source.get();
            this.updateBlock(new long[]{first});
            this.filter = factory.newFilter(first);
        }
        this.packer = packer;
        this.chunkSize = this.packer.getBlockSize();
    }

    @Override
    public void fetchBlock(LongOutputStream dst) {
        if (this.availableLen >= this.chunkSize) {
            try {
                this.packer.decompress(this.source, dst, this.filter, 1);
                this.availableLen -= this.chunkSize;
            }
            catch (BufferUnderflowException bufferUnderflowException) {}
        } else if (this.availableLen > 0) {
            long[] last = new long[this.chunkSize];
            LongBuffer buf = LongBuffer.wrap(last);
            try {
                this.packer.decompress(this.source, new LongBufferOutputStream(buf), this.filter, 1);
                dst.write(last, 0, this.availableLen);
                this.availableLen = 0;
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                // empty catch block
            }
        }
    }
}

