/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.packers;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.IntCodec;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.IntFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.ThroughIntFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.IntOutputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.utils.IntBitPackingPacks;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.utils.IntBitPackingUnpacks;
import java.nio.IntBuffer;

public class IntBitPacking
extends IntCodec {
    public static final int BLOCK_LEN = 32;
    public static final int BLOCK_NUM = 4;
    private static final int[] MASKS = IntBitPacking.newMasks();
    private static final IntFilter THROUGH_FILTER = new ThroughIntFilter();
    private boolean debug = false;
    private final int blockLen;
    private final int blockNum;
    private final int[] maxBits;
    private final int[] packBuf;
    private final int[] unpackBuf;

    public IntBitPacking(int blockLen, int blockNum) {
        this.blockLen = blockLen;
        this.blockNum = blockNum;
        this.maxBits = new int[blockNum];
        this.packBuf = new int[blockLen];
        this.unpackBuf = new int[blockLen];
    }

    public IntBitPacking() {
        this(32, 4);
    }

    public IntBitPacking setDebug(boolean value) {
        this.debug = value;
        return this;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public int getBlockLen() {
        return this.blockLen;
    }

    public int getBlockNum() {
        return this.blockNum;
    }

    public int getBlockSize() {
        return this.blockLen * this.blockNum;
    }

    public static int[] newMasks() {
        int[] masks = new int[33];
        int m = -1;
        for (int i = 32; i >= 0; --i) {
            masks[i] = m;
            m >>>= 1;
        }
        return masks;
    }

    public static int countMaxBits(IntBuffer buf, int len, IntFilter filter) {
        int n = 0;
        for (int i = len; i > 0; --i) {
            n |= filter.filterInt(buf.get());
        }
        return 32 - Integer.numberOfLeadingZeros(n);
    }

    public static int countMaxBits(IntBuffer buf, int len) {
        return IntBitPacking.countMaxBits(buf, len, THROUGH_FILTER);
    }

    public void pack(IntBuffer src, IntOutputStream dst, int validBits, int len) {
        this.pack(src, dst, validBits, len, THROUGH_FILTER);
    }

    public void pack(IntBuffer src, IntOutputStream dst, int validBits, int len, IntFilter filter) {
        switch (validBits) {
            case 0: {
                this.pack0(src, dst, len);
                break;
            }
            case 1: {
                IntBitPackingPacks.pack1(this.packBuf, src, dst, filter);
                break;
            }
            case 2: {
                IntBitPackingPacks.pack2(this.packBuf, src, dst, filter);
                break;
            }
            case 3: {
                IntBitPackingPacks.pack3(this.packBuf, src, dst, filter);
                break;
            }
            case 4: {
                IntBitPackingPacks.pack4(this.packBuf, src, dst, filter);
                break;
            }
            case 5: {
                IntBitPackingPacks.pack5(this.packBuf, src, dst, filter);
                break;
            }
            case 6: {
                IntBitPackingPacks.pack6(this.packBuf, src, dst, filter);
                break;
            }
            case 7: {
                IntBitPackingPacks.pack7(this.packBuf, src, dst, filter);
                break;
            }
            case 8: {
                IntBitPackingPacks.pack8(this.packBuf, src, dst, filter);
                break;
            }
            case 9: {
                IntBitPackingPacks.pack9(this.packBuf, src, dst, filter);
                break;
            }
            case 10: {
                IntBitPackingPacks.pack10(this.packBuf, src, dst, filter);
                break;
            }
            case 11: {
                IntBitPackingPacks.pack11(this.packBuf, src, dst, filter);
                break;
            }
            case 12: {
                IntBitPackingPacks.pack12(this.packBuf, src, dst, filter);
                break;
            }
            case 13: {
                IntBitPackingPacks.pack13(this.packBuf, src, dst, filter);
                break;
            }
            case 14: {
                IntBitPackingPacks.pack14(this.packBuf, src, dst, filter);
                break;
            }
            case 15: {
                IntBitPackingPacks.pack15(this.packBuf, src, dst, filter);
                break;
            }
            case 16: {
                IntBitPackingPacks.pack16(this.packBuf, src, dst, filter);
                break;
            }
            case 17: {
                IntBitPackingPacks.pack17(this.packBuf, src, dst, filter);
                break;
            }
            case 18: {
                IntBitPackingPacks.pack18(this.packBuf, src, dst, filter);
                break;
            }
            case 19: {
                IntBitPackingPacks.pack19(this.packBuf, src, dst, filter);
                break;
            }
            case 20: {
                IntBitPackingPacks.pack20(this.packBuf, src, dst, filter);
                break;
            }
            case 21: {
                IntBitPackingPacks.pack21(this.packBuf, src, dst, filter);
                break;
            }
            case 22: {
                IntBitPackingPacks.pack22(this.packBuf, src, dst, filter);
                break;
            }
            case 23: {
                IntBitPackingPacks.pack23(this.packBuf, src, dst, filter);
                break;
            }
            case 24: {
                IntBitPackingPacks.pack24(this.packBuf, src, dst, filter);
                break;
            }
            case 25: {
                IntBitPackingPacks.pack25(this.packBuf, src, dst, filter);
                break;
            }
            case 26: {
                IntBitPackingPacks.pack26(this.packBuf, src, dst, filter);
                break;
            }
            case 27: {
                IntBitPackingPacks.pack27(this.packBuf, src, dst, filter);
                break;
            }
            case 28: {
                IntBitPackingPacks.pack28(this.packBuf, src, dst, filter);
                break;
            }
            case 29: {
                IntBitPackingPacks.pack29(this.packBuf, src, dst, filter);
                break;
            }
            case 30: {
                IntBitPackingPacks.pack30(this.packBuf, src, dst, filter);
                break;
            }
            case 31: {
                IntBitPackingPacks.pack31(this.packBuf, src, dst, filter);
                break;
            }
            case 32: {
                IntBitPackingPacks.pack32(this.packBuf, src, dst, filter);
                break;
            }
            default: {
                throw new RuntimeException("Invalid bits: " + validBits);
            }
        }
    }

    public void pack0(IntBuffer src, IntOutputStream dst, int len) {
        src.position(src.position() + len);
    }

    public void packAny(IntBuffer src, IntOutputStream dst, int validBits, int len) {
        this.packAny(src, dst, validBits, len, THROUGH_FILTER);
    }

    public void packAny(IntBuffer src, IntOutputStream dst, int validBits, int len, IntFilter filter) {
        int current = 0;
        int capacity = 32;
        int mask = MASKS[validBits];
        int packIndex = 0;
        for (int i = len; i > 0; --i) {
            int n = filter.filterInt(src.get());
            if (capacity >= validBits) {
                current |= (n & mask) << capacity - validBits;
                if ((capacity -= validBits) != 0) continue;
                this.packBuf[packIndex++] = current;
                current = 0;
                capacity = 32;
                continue;
            }
            int remain = validBits - capacity;
            this.packBuf[packIndex++] = current |= n >> remain & MASKS[capacity];
            capacity = 32 - remain;
            current = (n & MASKS[remain]) << capacity;
        }
        if (capacity < 32) {
            this.packBuf[packIndex++] = current;
        }
        if (packIndex > 0) {
            dst.write(this.packBuf, 0, packIndex);
        }
    }

    public void compress(IntBuffer src, IntOutputStream dst, IntFilter filter) {
        while (src.remaining() >= this.blockLen * this.blockNum) {
            this.compressChunk(src, dst, filter);
        }
    }

    public void compressChunk(IntBuffer src, IntOutputStream dst, IntFilter filter) {
        int i;
        src.mark();
        filter.saveContext();
        int head = 0;
        for (i = 0; i < this.blockNum; ++i) {
            int n = this.maxBits[i] = IntBitPacking.countMaxBits(src, this.blockLen, filter);
            head = head << 8 | n;
        }
        filter.restoreContext();
        src.reset();
        dst.write(head);
        for (i = 0; i < this.blockNum; ++i) {
            this.pack(src, dst, this.maxBits[i], this.blockLen, filter);
        }
    }

    @Override
    public void compress(IntBuffer src, IntOutputStream dst) {
        this.compress(src, dst, THROUGH_FILTER);
    }

    public void unpack(IntBuffer src, IntOutputStream dst, int validBits, int len) {
        this.unpack(src, dst, validBits, len, THROUGH_FILTER);
    }

    public void unpack(IntBuffer src, IntOutputStream dst, int validBits, int len, IntFilter filter) {
        switch (validBits) {
            case 0: {
                this.unpack0(dst, filter);
                break;
            }
            case 1: {
                IntBitPackingUnpacks.unpack1(this.unpackBuf, src, dst, filter);
                break;
            }
            case 2: {
                IntBitPackingUnpacks.unpack2(this.unpackBuf, src, dst, filter);
                break;
            }
            case 3: {
                IntBitPackingUnpacks.unpack3(this.unpackBuf, src, dst, filter);
                break;
            }
            case 4: {
                IntBitPackingUnpacks.unpack4(this.unpackBuf, src, dst, filter);
                break;
            }
            case 5: {
                IntBitPackingUnpacks.unpack5(this.unpackBuf, src, dst, filter);
                break;
            }
            case 6: {
                IntBitPackingUnpacks.unpack6(this.unpackBuf, src, dst, filter);
                break;
            }
            case 7: {
                IntBitPackingUnpacks.unpack7(this.unpackBuf, src, dst, filter);
                break;
            }
            case 8: {
                IntBitPackingUnpacks.unpack8(this.unpackBuf, src, dst, filter);
                break;
            }
            case 9: {
                IntBitPackingUnpacks.unpack9(this.unpackBuf, src, dst, filter);
                break;
            }
            case 10: {
                IntBitPackingUnpacks.unpack10(this.unpackBuf, src, dst, filter);
                break;
            }
            case 11: {
                IntBitPackingUnpacks.unpack11(this.unpackBuf, src, dst, filter);
                break;
            }
            case 12: {
                IntBitPackingUnpacks.unpack12(this.unpackBuf, src, dst, filter);
                break;
            }
            case 13: {
                IntBitPackingUnpacks.unpack13(this.unpackBuf, src, dst, filter);
                break;
            }
            case 14: {
                IntBitPackingUnpacks.unpack14(this.unpackBuf, src, dst, filter);
                break;
            }
            case 15: {
                IntBitPackingUnpacks.unpack15(this.unpackBuf, src, dst, filter);
                break;
            }
            case 16: {
                IntBitPackingUnpacks.unpack16(this.unpackBuf, src, dst, filter);
                break;
            }
            case 17: {
                IntBitPackingUnpacks.unpack17(this.unpackBuf, src, dst, filter);
                break;
            }
            case 18: {
                IntBitPackingUnpacks.unpack18(this.unpackBuf, src, dst, filter);
                break;
            }
            case 19: {
                IntBitPackingUnpacks.unpack19(this.unpackBuf, src, dst, filter);
                break;
            }
            case 20: {
                IntBitPackingUnpacks.unpack20(this.unpackBuf, src, dst, filter);
                break;
            }
            case 21: {
                IntBitPackingUnpacks.unpack21(this.unpackBuf, src, dst, filter);
                break;
            }
            case 22: {
                IntBitPackingUnpacks.unpack22(this.unpackBuf, src, dst, filter);
                break;
            }
            case 23: {
                IntBitPackingUnpacks.unpack23(this.unpackBuf, src, dst, filter);
                break;
            }
            case 24: {
                IntBitPackingUnpacks.unpack24(this.unpackBuf, src, dst, filter);
                break;
            }
            case 25: {
                IntBitPackingUnpacks.unpack25(this.unpackBuf, src, dst, filter);
                break;
            }
            case 26: {
                IntBitPackingUnpacks.unpack26(this.unpackBuf, src, dst, filter);
                break;
            }
            case 27: {
                IntBitPackingUnpacks.unpack27(this.unpackBuf, src, dst, filter);
                break;
            }
            case 28: {
                IntBitPackingUnpacks.unpack28(this.unpackBuf, src, dst, filter);
                break;
            }
            case 29: {
                IntBitPackingUnpacks.unpack29(this.unpackBuf, src, dst, filter);
                break;
            }
            case 30: {
                IntBitPackingUnpacks.unpack30(this.unpackBuf, src, dst, filter);
                break;
            }
            case 31: {
                IntBitPackingUnpacks.unpack31(this.unpackBuf, src, dst, filter);
                break;
            }
            case 32: {
                IntBitPackingUnpacks.unpack32(this.unpackBuf, src, dst, filter);
                break;
            }
            default: {
                throw new RuntimeException("Invalid bits: " + validBits);
            }
        }
    }

    private void unpack0(IntOutputStream dst, IntFilter filter) {
        for (int i = 0; i < this.blockLen; ++i) {
            this.unpackBuf[i] = filter.filterInt(0);
        }
        dst.write(this.unpackBuf);
    }

    public void unpackAny(IntBuffer src, IntOutputStream dst, int validBits, int len) {
        this.unpackAny(src, dst, validBits, len, THROUGH_FILTER);
    }

    public void unpackAny(IntBuffer src, IntOutputStream dst, int validBits, int len, IntFilter filter) {
        int fetchedData = 0;
        int fetchedBits = 0;
        int mask = MASKS[validBits];
        for (int i = 0; i < len; ++i) {
            int n;
            if (fetchedBits < validBits) {
                int n0 = fetchedBits > 0 ? fetchedData << validBits - fetchedBits : 0;
                fetchedData = src.get();
                n = (n0 | fetchedData >>> (fetchedBits += 32 - validBits)) & mask;
            } else {
                n = fetchedData >>> (fetchedBits -= validBits) & mask;
            }
            this.unpackBuf[i] = filter.filterInt(n);
        }
        dst.write(this.unpackBuf, 0, len);
    }

    public void decompress(IntBuffer src, IntOutputStream dst, IntFilter filter, int numOfChunks) {
        for (int i = numOfChunks; i > 0; --i) {
            int head = src.get();
            for (int j = (this.blockNum - 1) * 8; j >= 0; j -= 8) {
                int validBits = head >> j & 0xFF;
                this.unpack(src, dst, validBits, this.blockLen, filter);
            }
        }
    }

    protected void decompress(IntBuffer src, IntOutputStream dst, IntFilter filter) {
        while (src.hasRemaining()) {
            int head = src.get();
            for (int i = (this.blockNum - 1) * 8; i >= 0; i -= 8) {
                int validBits = head >> i & 0xFF;
                this.unpack(src, dst, validBits, this.blockLen, filter);
            }
        }
    }

    @Override
    public void decompress(IntBuffer src, IntOutputStream dst) {
        this.decompress(src, dst, THROUGH_FILTER);
    }

    public static byte[] toBytes(int[] src) {
        return new IntBitPacking().compress(src);
    }

    public static int[] fromBytes(byte[] src) {
        return new IntBitPacking().decompress(src);
    }
}

