/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.packers;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.LongCodec;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.LongFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.ThroughLongFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.LongOutputStream;
import java.nio.LongBuffer;

public class LongBitPacking
extends LongCodec {
    public static final int BLOCK_LEN = 16;
    public static final int BLOCK_NUM = 4;
    private static final long[] MASKS = LongBitPacking.newMasks();
    private static final LongFilter THROUGH_FILTER = new ThroughLongFilter();
    private boolean debug = false;
    private final int blockLen;
    private final int blockNum;
    private final int[] maxBits;
    private final long[] packBuf;

    public LongBitPacking(int blockLen, int blockNum) {
        this.blockLen = blockLen;
        this.blockNum = blockNum;
        this.maxBits = new int[blockNum];
        this.packBuf = new long[blockLen];
    }

    public LongBitPacking() {
        this(16, 4);
    }

    public LongBitPacking setDebug(boolean value) {
        this.debug = value;
        return this;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public int getBlockLen() {
        return this.blockLen;
    }

    public int getBlockNum() {
        return this.blockNum;
    }

    public int getBlockSize() {
        return this.blockLen * this.blockNum;
    }

    public static long[] newMasks() {
        long[] masks = new long[65];
        long m = -1L;
        for (int i = 64; i >= 0; --i) {
            masks[i] = m;
            m >>>= 1;
        }
        return masks;
    }

    public static int countMaxBits(LongBuffer buf, int len, LongFilter filter) {
        long n = 0L;
        for (int i = len; i > 0; --i) {
            n |= filter.filterLong(buf.get());
        }
        return 64 - Long.numberOfLeadingZeros(n);
    }

    public static int countMaxBits(LongBuffer buf, int len) {
        return LongBitPacking.countMaxBits(buf, len, THROUGH_FILTER);
    }

    public void pack(LongBuffer src, LongOutputStream dst, int validBits, int len) {
        this.pack(src, dst, validBits, len, THROUGH_FILTER);
    }

    public void pack(LongBuffer src, LongOutputStream dst, int validBits, int len, LongFilter filter) {
        switch (validBits) {
            case 0: {
                this.pack0(src, dst, len);
                break;
            }
            default: {
                this.packAny(src, dst, validBits, len, filter);
            }
        }
    }

    public void pack0(LongBuffer src, LongOutputStream dst, int len) {
        src.position(src.position() + len);
    }

    public void packAny(LongBuffer src, LongOutputStream dst, int validBits, int len) {
        this.packAny(src, dst, validBits, len, THROUGH_FILTER);
    }

    public void packAny(LongBuffer src, LongOutputStream dst, int validBits, int len, LongFilter filter) {
        long current = 0L;
        int capacity = 64;
        long mask = MASKS[validBits];
        int packIndex = 0;
        for (int i = len; i > 0; --i) {
            long n = filter.filterLong(src.get());
            if (capacity >= validBits) {
                current |= (n & mask) << capacity - validBits;
                if ((capacity -= validBits) != 0) continue;
                this.packBuf[packIndex++] = current;
                current = 0L;
                capacity = 64;
                continue;
            }
            int remain = validBits - capacity;
            this.packBuf[packIndex++] = current |= n >> remain & MASKS[capacity];
            capacity = 64 - remain;
            current = (n & MASKS[remain]) << capacity;
        }
        if (capacity < 64) {
            this.packBuf[packIndex++] = current;
        }
        if (packIndex > 0) {
            dst.write(this.packBuf, 0, packIndex);
        }
    }

    public void compress(LongBuffer src, LongOutputStream dst, LongFilter filter) {
        int srclen = src.limit() - src.position();
        while (src.remaining() >= this.blockLen * this.blockNum) {
            this.compressChunk(src, dst, filter);
        }
    }

    public void compressChunk(LongBuffer src, LongOutputStream dst, LongFilter filter) {
        int i;
        src.mark();
        filter.saveContext();
        long head = 0L;
        for (i = 0; i < this.blockNum; ++i) {
            this.maxBits[i] = LongBitPacking.countMaxBits(src, this.blockLen, filter);
            long n = this.maxBits[i];
            head = head << 8 | n;
        }
        filter.restoreContext();
        src.reset();
        dst.write(head);
        for (i = 0; i < this.blockNum; ++i) {
            this.pack(src, dst, this.maxBits[i], this.blockLen, filter);
        }
    }

    @Override
    public void compress(LongBuffer src, LongOutputStream dst) {
        this.compress(src, dst, THROUGH_FILTER);
    }

    public static void unpack(LongBuffer src, LongOutputStream dst, int validBits, int len) {
        LongBitPacking.unpack(src, dst, validBits, len, THROUGH_FILTER);
    }

    public static void unpack(LongBuffer src, LongOutputStream dst, int validBits, int len, LongFilter filter) {
        long fetchedData = 0L;
        int fetchedBits = 0;
        long mask = MASKS[validBits];
        for (int i = len; i > 0; --i) {
            long n;
            if (fetchedBits < validBits) {
                long n0 = fetchedBits > 0 ? fetchedData << validBits - fetchedBits : 0L;
                fetchedData = src.get();
                n = (n0 | fetchedData >>> (fetchedBits += 64 - validBits)) & mask;
            } else {
                n = fetchedData >>> (fetchedBits -= validBits) & mask;
            }
            dst.write(filter.filterLong(n));
        }
    }

    public void decompress(LongBuffer src, LongOutputStream dst, LongFilter filter, int numOfChunks) {
        int[] maxBits = new int[this.blockNum];
        for (int i = numOfChunks; i > 0; --i) {
            long head = src.get();
            for (int j = (this.blockNum - 1) * 8; j >= 0; j -= 8) {
                int validBits = (int)(head >> j & 0xFFL);
                LongBitPacking.unpack(src, dst, validBits, this.blockLen, filter);
            }
        }
    }

    protected void decompress(LongBuffer src, LongOutputStream dst, LongFilter filter) {
        int[] maxBits = new int[this.blockNum];
        while (src.hasRemaining()) {
            long head = src.get();
            for (int i = (this.blockNum - 1) * 8; i >= 0; i -= 8) {
                int validBits = (int)(head >> i & 0xFFL);
                LongBitPacking.unpack(src, dst, validBits, this.blockLen, filter);
            }
        }
    }

    @Override
    public void decompress(LongBuffer src, LongOutputStream dst) {
        this.decompress(src, dst, THROUGH_FILTER);
    }

    public static byte[] toBytes(long[] src) {
        return new LongBitPacking().compress(src);
    }

    public static byte[] toBytes(long[] src, int offset, int length) {
        return new LongBitPacking().compress(src, offset, length);
    }

    public static long[] fromBytes(byte[] src) {
        return new LongBitPacking().decompress(src);
    }
}

