/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.utils;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.IntFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.IntFilterFactory;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.LongFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.LongFilterFactory;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.IntBufferOutputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.IntOutputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.LongBufferOutputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.LongOutputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.packers.IntBitPacking;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.packers.LongBitPacking;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Arrays;

public final class CodecUtils {
    public static void encodeBlockPack(IntBuffer src, IntFilterFactory filterFactory, IntBitPacking packer, IntOutputStream dst) {
        int srcLen = src.remaining();
        if (srcLen == 0) {
            return;
        }
        dst.write(srcLen);
        int first = src.get();
        dst.write(first);
        IntFilter filter = filterFactory.newFilter(first);
        int chunkSize = packer.getBlockSize();
        int chunkRemain = src.remaining() % chunkSize;
        IntBuffer window = src.slice();
        window.limit(window.limit() - chunkRemain);
        packer.compress(window, dst, filter);
        src.position(src.position() + window.position());
        if (chunkRemain > 0) {
            int[] last = new int[chunkSize];
            src.get(last, 0, chunkRemain);
            Arrays.fill(last, chunkRemain, last.length, last[chunkRemain - 1]);
            packer.compress(IntBuffer.wrap(last), dst, filter);
        }
    }

    public static void encodeBlockPack(LongBuffer src, LongFilterFactory filterFactory, LongBitPacking packer, LongOutputStream dst) {
        int srcLen = src.remaining();
        if (srcLen == 0) {
            return;
        }
        dst.write(srcLen);
        long first = src.get();
        dst.write(first);
        LongFilter filter = filterFactory.newFilter(first);
        int chunkSize = packer.getBlockSize();
        int chunkRemain = src.remaining() % chunkSize;
        LongBuffer window = src.slice();
        window.limit(window.limit() - chunkRemain);
        packer.compress(window, dst, filter);
        src.position(src.position() + window.position());
        if (chunkRemain > 0) {
            long[] last = new long[chunkSize];
            src.get(last, 0, chunkRemain);
            Arrays.fill(last, chunkRemain, last.length, last[chunkRemain - 1]);
            packer.compress(LongBuffer.wrap(last), dst, filter);
        }
    }

    public static void decodeBlockPack(IntBuffer src, IntFilterFactory filterFactory, IntBitPacking packer, IntOutputStream dst) {
        int chunkRemain;
        if (!src.hasRemaining()) {
            return;
        }
        int outLen = src.get() - 1;
        int first = src.get();
        dst.write(first);
        IntFilter filter = filterFactory.newFilter(first);
        int chunkSize = packer.getBlockSize();
        int chunkNum = outLen / chunkSize;
        if (chunkNum > 0) {
            packer.decompress(src, dst, filter, chunkNum);
        }
        if ((chunkRemain = outLen % chunkSize) > 0) {
            int[] last = new int[chunkSize];
            IntBuffer buf = IntBuffer.wrap(last);
            packer.decompress(src, new IntBufferOutputStream(buf), filter, 1);
            dst.write(last, 0, chunkRemain);
        }
    }

    public static void decodeBlockPack(LongBuffer src, LongFilterFactory filterFactory, LongBitPacking packer, LongOutputStream dst) {
        int chunkRemain;
        if (!src.hasRemaining()) {
            return;
        }
        int outLen = (int)src.get() - 1;
        long first = src.get();
        dst.write(first);
        LongFilter filter = filterFactory.newFilter(first);
        int chunkSize = packer.getBlockSize();
        int chunkNum = outLen / chunkSize;
        if (chunkNum > 0) {
            packer.decompress(src, dst, filter, chunkNum);
        }
        if ((chunkRemain = outLen % chunkSize) > 0) {
            long[] last = new long[chunkSize];
            LongBuffer buf = LongBuffer.wrap(last);
            packer.decompress(src, new LongBufferOutputStream(buf), filter, 1);
            dst.write(last, 0, chunkRemain);
        }
    }
}

