/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.server;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.bean.MetricResult;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.config.MetricsCollectPeriodConfig;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.DataSource;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.server.BasicLongArray;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.server.DataInfo;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.server.MetricsDataStore;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.status.LogDescriptionManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class MetricsMemoryCache
extends MetricsDataStore {
    private Map<MetricLevel, DataInfo> cachedMetrics = new HashMap<MetricLevel, DataInfo>();
    private int size = 10;
    private LogDescriptionManager logDescriptionManager;
    private MetricsCollectPeriodConfig metricsCollectPeriodConfig = new MetricsCollectPeriodConfig();
    private long startTime;
    private long endTime;

    public MetricsMemoryCache(int size, LogDescriptionManager logDescriptionManager) {
        this(size);
        this.logDescriptionManager = logDescriptionManager;
    }

    public MetricsMemoryCache(int size) {
        this.size = size;
        for (MetricLevel level : MetricLevel.values()) {
            int absoluteSize = size / this.metricsCollectPeriodConfig.period(level) * 2 - 1;
            this.cachedMetrics.put(level, new DataInfo(absoluteSize));
        }
    }

    public void add(MetricLevel level, long timestamp, long[] dataBlock) {
        DataInfo cache = this.cachedMetrics.get((Object)level);
        cache.add(timestamp, dataBlock);
        if (timestamp > this.endTime) {
            this.endTime = timestamp;
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Map<MetricLevel, SortedMap<Long, List<MetricResult>>> getDataFromCache(Map<MetricLevel, SortedMap<Long, List<MetricResult>>> result, Map<MetricLevel, Set<DataSource>> dataSources, long startTime, long endTime, int precision) {
        if (dataSources == null || dataSources.size() == 0) {
            return result;
        }
        for (Map.Entry<MetricLevel, Set<DataSource>> entry : dataSources.entrySet()) {
            MetricLevel level = entry.getKey();
            Set<DataSource> dataSourceSet = entry.getValue();
            DataInfo info = this.cachedMetrics.get((Object)level);
            SortedMap timeSeries = info.getDataMap().subMap((Object)startTime, (Object)endTime);
            SortedMap<Long, List<MetricResult>> resultList = result.get((Object)level);
            if (resultList == null) {
                TreeMap<Long, List<MetricResult>> newMap = new TreeMap<Long, List<MetricResult>>();
                result.put(level, newMap);
                resultList = newMap;
            }
            for (Map.Entry entry1 : timeSeries.entrySet()) {
                long key = (Long)entry1.getKey();
                List<MetricResult> tempResult = (List<MetricResult>)resultList.get(key);
                tempResult = this.createMetricsResult(dataSourceSet, ((BasicLongArray)entry1.getValue()).array, key, level, precision, tempResult);
                resultList.put(key, tempResult);
            }
            result.put(level, resultList);
        }
        return result;
    }
}

