/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.server;

import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Compass;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Counter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.ReservoirType;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.bean.MetricResult;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.bean.MetricSearch;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.bean.MetricSource;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.bean.MetricsDataStatus;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.bean.MetricsRecordStatus;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.bean.MetricsSearchRequest;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.bean.MetricsSearchResponse;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.config.MetricsCollectPeriodConfig;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.DataSource;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.IndexData;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.server.MetricsMemoryCache;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.server.MetricsOnDisk;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.status.LogDescriptionManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.status.LogDescriptionRegister;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.utils.FigureUtil;
import com.alibaba.csp.ahas.shaded.org.slf4j.Logger;
import com.alibaba.csp.ahas.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;

public class MetricsSearchService {
    private static final Logger logger = LoggerFactory.getLogger(MetricsSearchService.class);
    private static LogDescriptionManager logDescriptionManager;
    private static MetricsSearchService instance;
    private static MetricsMemoryCache cache;
    private static MetricsOnDisk disk;
    private MetricsCollectPeriodConfig metricsCollectPeriodConfig = new MetricsCollectPeriodConfig();
    private static int MAX_SEARCH_INTERVAL;
    private Counter cacheHit = MetricManager.getCounter("situation_awareness", new MetricName("middleware.metrics.cache.hit"));
    private Counter cachePartsHit = MetricManager.getCounter("situation_awareness", new MetricName("middleware.metrics.cache.parts_hit"));
    private Counter cacheMiss = MetricManager.getCounter("situation_awareness", new MetricName("middleware.metrics.cache.miss"));
    private Compass dataRead = MetricManager.getCompass("situation_awareness", new MetricName("middleware.metrics.cache.data_read"), ReservoirType.BUCKET);
    private Counter currentDayAccess = MetricManager.getCounter("situation_awareness", new MetricName("middleware.metrics.cache.current_access"));
    private Counter passedDayAccess = MetricManager.getCounter("situation_awareness", new MetricName("middleware.metrics.cache.passed_access"));
    private Counter dataCollected = MetricManager.getCounter("situation_awareness", new MetricName("middleware.metrics.cache.data_collected"));
    private Counter dataUnfinished = MetricManager.getCounter("situation_awareness", new MetricName("middleware.metrics.cache.data_unfinished"));

    public static void build(MetricsMemoryCache cache, MetricsOnDisk disk, LogDescriptionManager logDescriptionManager) {
        MetricsSearchService.cache = cache;
        MetricsSearchService.disk = disk;
        MetricsSearchService.logDescriptionManager = logDescriptionManager;
    }

    public String search(String metricsSearch) {
        logger.debug(metricsSearch);
        String result = "";
        try {
            MetricsSearchRequest request = JSON.parseObject(metricsSearch, MetricsSearchRequest.class);
            MetricsSearchResponse response = this.search(request);
            result = JSON.toJSONString((Object)response, SerializerFeature.DisableCircularReferenceDetect);
        }
        catch (Exception e) {
            logger.error("An error occur in searching! Search json is: " + metricsSearch, e);
        }
        return result;
    }

    public MetricsSearchResponse search(MetricsSearchRequest request) {
        long startTime = request.getStartTime();
        long endTime = request.getEndTime();
        int limit = request.getLimit();
        int precision = request.getPrecision();
        List<MetricSearch> metricNames = request.getQueries();
        boolean zeroIgnore = request.isZeroIgnore();
        long currentTimeStamp = System.currentTimeMillis();
        long todayBaseTime = FigureUtil.getTodayStartTimestamp(currentTimeStamp);
        MetricsSearchResponse response = new MetricsSearchResponse();
        ArrayList<MetricResult> resultList = new ArrayList<MetricResult>();
        MetricSource source = request.getSource();
        Map<MetricLevel, SortedMap<Long, List<MetricResult>>> results = this.distinguishSearch(startTime, endTime, currentTimeStamp, precision, metricNames, source);
        long range = endTime - startTime;
        if (range > 86400000L) {
            startTime = endTime - 86400000L;
            logger.warn("The time range of this search is too large, reset starttime to {}", (Object)startTime);
        }
        response.setStartTime(startTime);
        response.setEndTime(endTime);
        for (Map.Entry<MetricLevel, SortedMap<Long, List<MetricResult>>> entry : results.entrySet()) {
            SortedMap<Long, List<MetricResult>> classifiedResult = entry.getValue();
            if (classifiedResult == null || classifiedResult.size() <= 0) continue;
            for (Map.Entry<Long, List<MetricResult>> entry1 : classifiedResult.entrySet()) {
                List<MetricResult> metricResults = entry1.getValue();
                if (metricResults == null || metricResults.size() <= 0) continue;
                resultList.addAll(metricResults);
            }
        }
        boolean collected = this.checkFinishStatus(results, endTime);
        if (collected) {
            response.setDataStatus(MetricsDataStatus.COLLECTED);
            this.dataCollected.inc();
        } else {
            response.setDataStatus(MetricsDataStatus.UNFINISHED);
            this.dataUnfinished.inc();
        }
        if (limit > 0) {
            if (resultList.size() > limit) {
                response.setResult(resultList.subList(0, limit - 1));
                response.setRecordStatus(MetricsRecordStatus.LIMITED);
            } else {
                response.setResult(resultList);
                response.setRecordStatus(MetricsRecordStatus.ENTIRE);
            }
        } else {
            response.setResult(resultList);
            response.setRecordStatus(MetricsRecordStatus.ENTIRE);
        }
        if (zeroIgnore) {
            ArrayList<MetricResult> allResultList = resultList;
            resultList = new ArrayList();
            for (MetricResult result : allResultList) {
                if (FigureUtil.checkZero(result.getValue())) continue;
                resultList.add(result);
            }
            response.setResult(resultList);
        }
        return response;
    }

    private Map<MetricLevel, SortedMap<Long, List<MetricResult>>> distinguishSearch(long startTime, long endTime, long currentTimeStamp, int precision, List<MetricSearch> metricNames, MetricSource source) {
        if (source == MetricSource.CURRENT || source == MetricSource.ARCHIVE) {
            // empty if block
        }
        Map<MetricLevel, SortedMap<Long, List<MetricResult>>> results = new HashMap<MetricLevel, SortedMap<Long, List<MetricResult>>>();
        long cacheUpperBound = currentTimeStamp / 1000L * 1000L - 120000L + 1000L;
        long cacheStartTime = 0L;
        cacheStartTime = cacheUpperBound < startTime ? startTime : cacheUpperBound;
        long cacheEndTime = endTime;
        if (cacheUpperBound < endTime) {
            LogDescriptionRegister logDescribeToday;
            long todayBaseTime = FigureUtil.getTodayStartTimestamp(currentTimeStamp);
            if (todayBaseTime <= startTime && todayBaseTime <= endTime) {
                this.currentDayAccess.inc();
                logDescribeToday = logDescriptionManager.getLogDescriptions(todayBaseTime);
                Map<MetricLevel, Set<DataSource>> dataSources = logDescribeToday.getMetricNames(metricNames);
                results = cache.getDataFromCache(results, dataSources, cacheStartTime, cacheEndTime, precision);
            } else if (todayBaseTime > startTime && todayBaseTime < endTime) {
                this.passedDayAccess.inc();
                logDescribeToday = logDescriptionManager.getLogDescriptions(todayBaseTime);
                Map<MetricLevel, Set<DataSource>> dataSourcesToday = logDescribeToday.getMetricNames(metricNames);
                results = cache.getDataFromCache(results, dataSourcesToday, todayBaseTime, cacheEndTime, precision);
                LogDescriptionRegister logDescribeYesterday = logDescriptionManager.getLogDescriptions(todayBaseTime - 86400000L);
                Map<MetricLevel, Set<DataSource>> dataSourcesYesterday = logDescribeYesterday.getMetricNames(metricNames);
                results = cache.getDataFromCache(results, dataSourcesYesterday, cacheStartTime, todayBaseTime - 1000L, precision);
            } else if (startTime < todayBaseTime && todayBaseTime < endTime) {
                this.passedDayAccess.inc();
                LogDescriptionRegister logDescribeYesterday = logDescriptionManager.getLogDescriptions(todayBaseTime - 86400000L);
                Map<MetricLevel, Set<DataSource>> dataSourcesYesterday = logDescribeYesterday.getMetricNames(metricNames);
                results = cache.getDataFromCache(results, dataSourcesYesterday, cacheStartTime, todayBaseTime - 1000L, precision);
            }
            if (startTime >= cacheUpperBound) {
                this.cacheHit.inc();
                return results;
            }
            this.cachePartsHit.inc();
        } else {
            this.cacheMiss.inc();
        }
        long remainingEndTime = 0L;
        remainingEndTime = endTime < cacheUpperBound ? endTime : cacheUpperBound;
        List<Long> timeSplit = FigureUtil.splitRangeByDay(startTime, remainingEndTime);
        int length = timeSplit.size() / 2;
        if (length > MAX_SEARCH_INTERVAL) {
            logger.warn("This query crosses {} days, exceed limit {}", (Object)length, (Object)MAX_SEARCH_INTERVAL);
            length = MAX_SEARCH_INTERVAL;
        }
        for (int i = 0; i < length; ++i) {
            long diskStartTime = timeSplit.get(2 * i);
            long diskEndTime = timeSplit.get(2 * i + 1);
            long baseTimestamp = FigureUtil.getTodayStartTimestamp(diskStartTime);
            LogDescriptionRegister logDescribeThisDay = logDescriptionManager.getLogDescriptions(baseTimestamp);
            Map<MetricLevel, Set<DataSource>> dataSourcesThisDay = logDescribeThisDay.getMetricNames(metricNames);
            if (dataSourcesThisDay == null || dataSourcesThisDay.size() == 0) continue;
            for (MetricLevel level : MetricLevel.values()) {
                Set<DataSource> dataSources;
                Map<Long, IndexData> indexs = logDescriptionManager.getIndexFromDisk(diskStartTime, diskEndTime, baseTimestamp, level);
                if (indexs == null || indexs.size() == 0 || (dataSources = dataSourcesThisDay.get((Object)level)) == null || dataSources.size() == 0) continue;
                long dataReadStart = System.currentTimeMillis();
                results = disk.getDataFromDisk(precision, level, dataSources, indexs, results);
                long dataReadEnd = System.currentTimeMillis();
                this.dataRead.update(dataReadEnd - dataReadStart, TimeUnit.MILLISECONDS);
            }
        }
        return results;
    }

    public static final MetricsSearchService getInstance() {
        if (instance == null) {
            instance = new MetricsSearchService();
        }
        return instance;
    }

    public boolean checkFinishStatus(Map<MetricLevel, SortedMap<Long, List<MetricResult>>> results, long endTime) {
        boolean collected = true;
        for (MetricLevel level : results.keySet()) {
            int interval = this.metricsCollectPeriodConfig.period(level) * 1000;
            long lastCollectionTime = logDescriptionManager.getLastCollectionTime(level);
            if (endTime < lastCollectionTime + (long)interval) continue;
            collected = false;
            break;
        }
        return collected;
    }

    static {
        MAX_SEARCH_INTERVAL = 2;
    }
}

