/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.tomcat;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CachedMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.PersistentGauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.tomcat.JMXUtils;
import com.alibaba.csp.ahas.shaded.org.slf4j.Logger;
import com.alibaba.csp.ahas.shaded.org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class HttpGaugeSet
extends CachedMetricSet {
    private static final Logger logger = LoggerFactory.getLogger(HttpGaugeSet.class);
    private static final String[] metricNames = new String[]{"request_count", "request.processing_time", "request.error_count", "request.max_time", "request.bytes_sent", "request.bytes_received"};
    private ObjectName globalReqProcessor;
    private MBeanServer mbeanServer;
    private Map<String, Long[]> connectorMetrics = new HashMap<String, Long[]>();
    private Map<String, Integer[]> failureStats;
    final Map<MetricName, Metric> gauges;

    public HttpGaugeSet() {
        this(JMXUtils.getMBeanServer(), DEFAULT_DATA_TTL, TimeUnit.MILLISECONDS, Clock.defaultClock());
    }

    public HttpGaugeSet(long dataTTL, TimeUnit unit) {
        this(JMXUtils.getMBeanServer(), dataTTL, unit, Clock.defaultClock());
    }

    public HttpGaugeSet(MBeanServer mbeanServer, long dataTTL, TimeUnit unit, Clock clock) {
        super(dataTTL, unit, clock);
        this.globalReqProcessor = JMXUtils.createObjectName("*:type=GlobalRequestProcessor,*");
        this.mbeanServer = mbeanServer;
        this.failureStats = new HashMap<String, Integer[]>();
        this.gauges = new HashMap<MetricName, Metric>();
        this.populateGauges();
    }

    @Override
    protected void getValueInternal() {
        ObjectName[] connectorNames;
        for (ObjectName connectorName : connectorNames = JMXUtils.getObjectNames(this.globalReqProcessor)) {
            String name = ObjectName.unquote(connectorName.getKeyProperty("name"));
            Long[] metrics = this.connectorMetrics.get(name);
            if (null == metrics) continue;
            try {
                metrics[HttpMetrics.REQUEST_COUNT.ordinal()] = (long)((Integer)this.mbeanServer.getAttribute(connectorName, "requestCount"));
                metrics[HttpMetrics.PROCESSING_TIME.ordinal()] = (Long)this.mbeanServer.getAttribute(connectorName, "processingTime");
                metrics[HttpMetrics.ERROR_COUNT.ordinal()] = (long)((Integer)this.mbeanServer.getAttribute(connectorName, "errorCount"));
                metrics[HttpMetrics.MAX_TIME.ordinal()] = (Long)this.mbeanServer.getAttribute(connectorName, "maxTime");
                metrics[HttpMetrics.BYTES_RECEIVED.ordinal()] = (Long)this.mbeanServer.getAttribute(connectorName, "bytesReceived");
                metrics[HttpMetrics.BYTES_SENT.ordinal()] = (Long)this.mbeanServer.getAttribute(connectorName, "bytesSent");
            }
            catch (Exception e) {
                logger.error("Exception occur when getting connector global stats: ", e);
            }
            try {
                Object attribute = this.mbeanServer.getAttribute(connectorName, "requestFailureCount");
                if (attribute == null) continue;
                Integer[] data = (Integer[])attribute;
                for (int i = 0; i < data.length; ++i) {
                    this.failureStats.get((Object)name)[i] = data[i];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        return this.gauges;
    }

    private void populateGauges() {
        ObjectName[] connectorNames;
        for (ObjectName connectorName : connectorNames = JMXUtils.getObjectNames(this.globalReqProcessor)) {
            String name = ObjectName.unquote(connectorName.getKeyProperty("name"));
            this.connectorMetrics.put(name, new Long[HttpMetrics.values().length]);
        }
        for (Map.Entry<String, Long[]> entry : this.connectorMetrics.entrySet()) {
            for (HttpMetrics metric : HttpMetrics.values()) {
                this.gauges.put(MetricName.build(metricNames[metric.ordinal()]).tagged("connector", entry.getKey()), new HttpStatGauge<Object>((Object[])entry.getValue(), metric.ordinal()));
            }
        }
    }

    private class HttpStatGauge<T>
    extends PersistentGauge {
        private T[] dataArray;
        private int index;

        public HttpStatGauge(T[] dataArray, int index) {
            this.dataArray = dataArray;
            this.index = index;
        }

        @Override
        public T getValue() {
            HttpGaugeSet.this.refreshIfNecessary();
            return this.dataArray[this.index];
        }
    }

    private static enum HttpMetrics {
        REQUEST_COUNT,
        PROCESSING_TIME,
        ERROR_COUNT,
        MAX_TIME,
        BYTES_SENT,
        BYTES_RECEIVED;

    }
}

