/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.tomcat;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

public class JMXUtils {
    public static ObjectName register(String name, Object mbean) {
        try {
            ObjectName objectName = new ObjectName(name);
            MBeanServer mbeanServer = JMXUtils.getMBeanServer();
            try {
                mbeanServer.registerMBean(mbean, objectName);
            }
            catch (InstanceAlreadyExistsException ex) {
                mbeanServer.unregisterMBean(objectName);
                mbeanServer.registerMBean(mbean, objectName);
            }
            return objectName;
        }
        catch (JMException e) {
            throw new IllegalArgumentException(name, e);
        }
    }

    public static void unregister(String name) {
        try {
            MBeanServer mbeanServer = JMXUtils.getMBeanServer();
            mbeanServer.unregisterMBean(new ObjectName(name));
        }
        catch (JMException e) {
            throw new IllegalArgumentException(name, e);
        }
    }

    public static ObjectName createObjectName(String pattern) {
        try {
            return new ObjectName(pattern);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ObjectName[] getObjectNames(ObjectName pattern) {
        ObjectName[] result = new ObjectName[]{};
        Set<ObjectName> objectNames = JMXUtils.getMBeanServer().queryNames(pattern, null);
        if (objectNames != null && !objectNames.isEmpty()) {
            result = objectNames.toArray(new ObjectName[objectNames.size()]);
        }
        return result;
    }

    public static MBeanServer getMBeanServer() {
        MBeanServer mBeanServer = null;
        mBeanServer = MBeanServerFactory.findMBeanServer(null).size() > 0 ? MBeanServerFactory.findMBeanServer(null).get(0) : ManagementFactory.getPlatformMBeanServer();
        return mBeanServer;
    }
}

