/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.client.codec;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.compress.CompressUtil;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.protocol.AgwMessage;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.protocol.AgwMessageHeader;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.AgwStringUtil;
import com.alibaba.csp.ahas.shaded.io.netty.buffer.ByteBuf;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelHandlerContext;
import com.alibaba.csp.ahas.shaded.io.netty.handler.codec.ByteToMessageCodec;
import java.nio.charset.Charset;
import java.util.List;

public class ProtocolHandler
extends ByteToMessageCodec<AgwMessage> {
    public static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");

    @Override
    protected void encode(ChannelHandlerContext ctx, AgwMessage msg, ByteBuf out) throws Exception {
        AgwMessageHeader header = msg.getHeader();
        String bodyStr = msg.getBody();
        if (header == null) {
            return;
        }
        if (bodyStr == null) {
            return;
        }
        byte[] body = null;
        int compress = header.getVersion() & 7;
        body = compress == 2 ? CompressUtil.compress(bodyStr) : (compress == 3 && header.getMessageDirection() == 1 ? CompressUtil.compress(bodyStr) : (compress == 4 && header.getMessageDirection() == 2 ? CompressUtil.compress(bodyStr) : bodyStr.getBytes(CHARSET_UTF8)));
        out.writeInt(body.length);
        out.writeLong(header.getReqId());
        out.writeByte(header.getMessageType());
        out.writeByte(header.getMessageDirection());
        out.writeByte(header.getCaller());
        out.writeLong(header.getClientIp());
        out.writeInt(header.getClientVpcId().getBytes(CHARSET_UTF8).length);
        out.writeBytes(header.getClientVpcId().getBytes(CHARSET_UTF8));
        out.writeInt(header.getServerName().getBytes(CHARSET_UTF8).length);
        out.writeBytes(header.getServerName().getBytes(CHARSET_UTF8));
        out.writeInt(header.getTimeoutMs());
        out.writeInt(header.getClientProcessFlag().getBytes(CHARSET_UTF8).length);
        out.writeBytes(header.getClientProcessFlag().getBytes(CHARSET_UTF8));
        out.writeInt(header.getInnerCode());
        out.writeInt(header.getInnerMsg().getBytes(CHARSET_UTF8).length);
        out.writeBytes(header.getInnerMsg().getBytes(CHARSET_UTF8));
        out.writeInt(header.getConnectionId());
        out.writeInt(header.getHandlerName().getBytes(CHARSET_UTF8).length);
        out.writeBytes(header.getHandlerName().getBytes(CHARSET_UTF8));
        out.writeInt(header.getOuterReqId().getBytes(CHARSET_UTF8).length);
        out.writeBytes(header.getOuterReqId().getBytes(CHARSET_UTF8));
        out.writeInt(header.getVersion());
        if (!AgwStringUtil.isBlank(header.getClientIpv6())) {
            out.writeByte(header.getClientIpv6().getBytes(CHARSET_UTF8).length);
            out.writeBytes(header.getClientIpv6().getBytes(CHARSET_UTF8));
        }
        out.writeBytes(body);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int originPos;
        block12: {
            byte[] clientIpv6;
            byte clientIpv6Length;
            int version;
            byte[] outerReqId;
            byte[] handlerName;
            int connectionId;
            byte[] innerMsg;
            int innerMsgLength;
            int innerCode;
            byte[] userProcessFlag;
            int userProcessFlagLength;
            int timeoutMs;
            byte[] appName;
            int appNameLength;
            byte[] userVpcId;
            int userVpcIdLength;
            long clientIp;
            byte caller;
            byte messageDirection;
            byte messageType;
            long reqId;
            int bodyLength;
            block13: {
                originPos = in.readerIndex();
                if (in.readableBytes() < 27) break block12;
                bodyLength = in.readInt();
                reqId = in.readLong();
                messageType = in.readByte();
                messageDirection = in.readByte();
                caller = in.readByte();
                clientIp = in.readLong();
                userVpcIdLength = in.readInt();
                if (in.readableBytes() < userVpcIdLength) break block12;
                userVpcId = new byte[userVpcIdLength];
                in.readBytes(userVpcId);
                if (in.readableBytes() < 4) break block12;
                appNameLength = in.readInt();
                if (in.readableBytes() < appNameLength) break block12;
                appName = new byte[appNameLength];
                in.readBytes(appName);
                if (in.readableBytes() < 4) break block12;
                timeoutMs = in.readInt();
                if (in.readableBytes() < 4) break block12;
                userProcessFlagLength = in.readInt();
                if (in.readableBytes() < userProcessFlagLength) break block12;
                userProcessFlag = new byte[userProcessFlagLength];
                in.readBytes(userProcessFlag);
                if (in.readableBytes() < 4) break block12;
                innerCode = in.readInt();
                if (in.readableBytes() < 4) break block12;
                innerMsgLength = in.readInt();
                if (in.readableBytes() < innerMsgLength) break block12;
                innerMsg = new byte[innerMsgLength];
                in.readBytes(innerMsg);
                if (in.readableBytes() < 4) break block12;
                connectionId = in.readInt();
                if (in.readableBytes() < 4) break block12;
                int handlerNameLength = in.readInt();
                if (in.readableBytes() < handlerNameLength) break block12;
                handlerName = new byte[handlerNameLength];
                in.readBytes(handlerName);
                if (in.readableBytes() < 4) break block12;
                int outerReqIdLength = in.readInt();
                if (in.readableBytes() < outerReqIdLength) break block12;
                outerReqId = new byte[outerReqIdLength];
                in.readBytes(outerReqId);
                if (in.readableBytes() < 4) break block12;
                version = in.readInt();
                clientIpv6Length = 0;
                clientIpv6 = null;
                if (clientIp != Long.MAX_VALUE) break block13;
                if (in.readableBytes() < 1) break block12;
                clientIpv6Length = in.readByte();
                if (in.readableBytes() < clientIpv6Length) break block12;
                clientIpv6 = new byte[clientIpv6Length];
                in.readBytes(clientIpv6);
            }
            if (in.readableBytes() >= bodyLength) {
                byte[] body = new byte[bodyLength];
                in.readBytes(body);
                AgwMessageHeader header = new AgwMessageHeader();
                header.setBodyLength(bodyLength);
                header.setReqId(reqId);
                header.setMessageType(messageType);
                header.setMessageDirection(messageDirection);
                header.setCaller(caller);
                header.setClientIp(clientIp);
                header.setClientVpcIdLength(userVpcIdLength);
                header.setClientVpcId(new String(userVpcId, CHARSET_UTF8));
                header.setServerNameLength(appNameLength);
                header.setServerName(new String(appName, CHARSET_UTF8));
                header.setTimeoutMs(timeoutMs);
                header.setClientProcessFlagLength(userProcessFlagLength);
                header.setClientProcessFlag(new String(userProcessFlag, CHARSET_UTF8));
                header.setInnerCode(innerCode);
                header.setInnerMsgLength(innerMsgLength);
                header.setInnerMsg(new String(innerMsg, CHARSET_UTF8));
                header.setConnectionId(connectionId);
                header.setHandlerName(new String(handlerName, CHARSET_UTF8));
                header.setOuterReqId(new String(outerReqId, CHARSET_UTF8));
                header.setVersion(version);
                if (clientIpv6Length > 0) {
                    header.setClientIpv6Length(clientIpv6Length);
                    header.setClientIpv6(new String(clientIpv6, CHARSET_UTF8));
                }
                AgwMessage message = new AgwMessage();
                message.setHeader(header);
                int compress = header.getVersion() & 7;
                if (compress == 2) {
                    message.setBody(CompressUtil.uncompress(body));
                } else if (compress == 3 && header.getMessageDirection() == 1) {
                    message.setBody(CompressUtil.uncompress(body));
                } else if (compress == 4 && header.getMessageDirection() == 2) {
                    message.setBody(CompressUtil.uncompress(body));
                } else {
                    message.setBody(new String(body, CHARSET_UTF8));
                }
                if (header.getMessageDirection() == 1) {
                    message.init(message.getBody().getBytes("UTF-8").length, body.length, compress);
                }
                out.add(message);
                return;
            }
        }
        in.setIndex(originPos, in.writerIndex());
    }
}

