/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.protocol;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.protocol.AgwMessageHeader;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.AgwStringUtil;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.misc.IpUtil;
import sun.net.util.IPAddressUtil;

public abstract class AbstractMessageBuilder {
    public AgwMessageHeader buildMessageHeader(String userVpcId, String userIp, String userProcessFlag, String handlerName, int connectionId, String appName, int readTimeoutMs, boolean requestCompress, boolean responseCompress) {
        if (AgwStringUtil.isBlank(userVpcId)) {
            return null;
        }
        if (AgwStringUtil.isBlank(userIp)) {
            return null;
        }
        if (AgwStringUtil.isBlank(userProcessFlag)) {
            return null;
        }
        if (AgwStringUtil.isBlank(handlerName)) {
            return null;
        }
        if (connectionId < 0) {
            return null;
        }
        if (AgwStringUtil.isBlank(appName)) {
            return null;
        }
        if (readTimeoutMs < 0) {
            return null;
        }
        AgwMessageHeader header = new AgwMessageHeader();
        header.setClientVpcId(userVpcId);
        if (IPAddressUtil.isIPv6LiteralAddress(userIp)) {
            header.setClientIpv6(userIp);
            header.setClientIp(Long.MAX_VALUE);
        } else if (IPAddressUtil.isIPv4LiteralAddress(userIp)) {
            header.setClientIp(IpUtil.ipToLong(userIp));
        } else {
            return null;
        }
        header.setConnectionId(connectionId);
        header.setServerName(appName);
        header.setTimeoutMs(readTimeoutMs);
        header.setHandlerName(handlerName);
        header.setClientProcessFlag(userProcessFlag);
        if (!requestCompress && !responseCompress) {
            header.setVersion(1);
        } else if (requestCompress && responseCompress) {
            header.setVersion(2);
        } else if (requestCompress && !responseCompress) {
            header.setVersion(3);
        } else if (!requestCompress && responseCompress) {
            header.setVersion(4);
        }
        return this.buildMessageHeader0(header);
    }

    protected abstract AgwMessageHeader buildMessageHeader0(AgwMessageHeader var1);

    public abstract String buildMessageBody(String var1);
}

