/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.log;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.log.AgwLogBase;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.misc.AgwPidUtil;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.thread.NamedThreadFactory;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

class AgwDateFileLogHandler
extends Handler {
    private final ThreadLocal<SimpleDateFormat> dateFormatThreadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    private ExecutorService pool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(512), new NamedThreadFactory("ahas-agw-logger-print-scheduler", true), new ThreadPoolExecutor.DiscardOldestPolicy());
    private volatile FileHandler handler;
    private final String fileNamePattern;
    private final String filePathPrefix;
    private final int limit;
    private final int count;
    private final boolean append;
    private volatile boolean initialized = false;
    private volatile long startDate = System.currentTimeMillis();
    private volatile long endDate;
    private final Object monitor = new Object();
    private final CompareByLastModified comparator = new CompareByLastModified();

    AgwDateFileLogHandler(String fileNamePattern, int limit, int count, boolean append) throws SecurityException {
        this.fileNamePattern = fileNamePattern;
        String filePathPrefix = AgwLogBase.getLogBaseDir() + fileNamePattern;
        if (AgwLogBase.isLogNameUsePid()) {
            filePathPrefix = filePathPrefix + ".pid" + AgwPidUtil.getPid();
        }
        this.filePathPrefix = filePathPrefix;
        this.limit = limit;
        this.count = count;
        this.append = append;
        this.rotateDate();
        this.initialized = true;
    }

    @Override
    public void close() throws SecurityException {
        if (this.handler != null) {
            this.handler.close();
        }
    }

    @Override
    public void flush() {
        if (this.handler != null) {
            this.handler.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(final LogRecord record) {
        if (record != null && this.shouldRotate(record)) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.shouldRotate(record)) {
                    this.rotateDate();
                }
            }
        }
        this.pool.execute(new Runnable(){

            @Override
            public void run() {
                if (AgwDateFileLogHandler.this.handler != null) {
                    AgwDateFileLogHandler.this.handler.publish(record);
                }
            }
        });
    }

    private boolean shouldRotate(LogRecord record) {
        return this.endDate <= record.getMillis() || !this.logFileExits();
    }

    @Override
    public void setFormatter(Formatter newFormatter) {
        super.setFormatter(newFormatter);
        if (this.handler != null) {
            this.handler.setFormatter(newFormatter);
        }
    }

    private boolean logFileExits() {
        try {
            SimpleDateFormat format = this.dateFormatThreadLocal.get();
            String fileName = String.format("%s.%s", this.filePathPrefix, format.format(new Date()));
            if (this.count != 1) {
                fileName = fileName + ".0";
            }
            File logFile = new File(fileName);
            return logFile.exists();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    private void rotateDate() {
        this.startDate = System.currentTimeMillis();
        if (this.handler != null) {
            this.handler.close();
        }
        SimpleDateFormat format = this.dateFormatThreadLocal.get();
        String newPattern = String.format("%s.%s", this.filePathPrefix, format.format(new Date()));
        Calendar next = Calendar.getInstance();
        next.set(11, 0);
        next.set(12, 0);
        next.set(13, 0);
        next.set(14, 0);
        next.add(5, 1);
        this.endDate = next.getTimeInMillis();
        try {
            this.removeTooOldFiles();
            this.removeMoreFiles();
            this.handler = new FileHandler(newPattern, this.limit, this.count, this.append);
            if (this.initialized) {
                this.handler.setEncoding(this.getEncoding());
                this.handler.setErrorManager(this.getErrorManager());
                this.handler.setFilter(this.getFilter());
                this.handler.setFormatter(this.getFormatter());
                this.handler.setLevel(this.getLevel());
            }
        }
        catch (Exception e) {
            System.err.println("Failed to rotate logs for " + this.fileNamePattern);
            e.printStackTrace();
        }
    }

    private void removeTooOldFiles() {
        File baseDir = new File(AgwLogBase.getLogBaseDir());
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            return;
        }
        File[] files = baseDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file == null) continue;
            String fileName = file.getName();
            if (!file.isFile() || !fileName.startsWith(this.fileNamePattern) || !this.matchOldFiles(fileName)) continue;
            file.delete();
        }
    }

    private boolean matchOldFiles(String newPattern) {
        if (!AgwDateFileLogHandler.isEmptyStr(newPattern)) {
            return false;
        }
        int secondIndex = newPattern.indexOf(46, newPattern.indexOf(46) + 1);
        String dateStr = newPattern.indexOf(46, secondIndex + 1) != -1 ? newPattern.substring(secondIndex + 1, newPattern.indexOf(46, secondIndex + 1)) : newPattern.substring(secondIndex + 1);
        SimpleDateFormat fileNameDf = this.dateFormatThreadLocal.get();
        if (!AgwDateFileLogHandler.isEmptyStr(dateStr)) {
            return false;
        }
        try {
            Date date = fileNameDf.parse(dateStr);
            if (date.getTime() < System.currentTimeMillis() - TimeUnit.DAYS.toMillis(AgwLogBase.getMaxHistoryDays())) {
                return true;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void removeMoreFiles() {
        File baseDir = new File(AgwLogBase.getLogBaseDir());
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            return;
        }
        File[] files = baseDir.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        ArrayList<File> fileList = new ArrayList<File>();
        for (File file : files) {
            if (file == null || !file.isFile() || !file.getName().startsWith(this.fileNamePattern)) continue;
            fileList.add(file);
        }
        Collections.sort(fileList, this.comparator);
        int deleteAmount = fileList.size() - AgwLogBase.getMaxTotalFileAmount();
        if (deleteAmount <= 0) {
            return;
        }
        for (int i = 0; i < deleteAmount; ++i) {
            if (fileList.get(i) == null) continue;
            ((File)fileList.get(i)).delete();
        }
    }

    public static boolean isEmptyStr(String str) {
        return str == null || str.length() == 0;
    }

    static class CompareByLastModified
    implements Comparator<File> {
        CompareByLastModified() {
        }

        @Override
        public int compare(File file1, File file2) {
            long diff = file1.lastModified() - file2.lastModified();
            if (diff > 0L) {
                return 1;
            }
            if (diff == 0L) {
                return 0;
            }
            return -1;
        }
    }
}

