/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.log;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.log.AgwDateFileLogHandler;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.log.AgwLogFormatter;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.log.AgwLoggerUtils;
import java.io.File;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AgwLogBase {
    public static final String LOG_DIR = "csp.sentinel.log.dir";
    public static final String LOG_NAME_USE_PID = "csp.sentinel.log.use.pid";
    public static final String LOG_MAX_SINGLE_FILE_SIZE_PROP_KEY = "csp.sentinel.logger.maxSingleFileSize";
    public static final String LOG_MAX_TOTAL_SIZE_CAP_PROP_KEY = "csp.sentinel.logger.maxTotalSizeCap";
    public static final String LOG_MAX_FILE_AMOUNT_PER_DAY_PROP_KEY = "csp.sentinel.logger.maxFileAmountPerDay";
    public static final String LOG_MAX_HISTORY_PROP_KEY = "csp.sentinel.logger.maxHistoryDays";
    public static final int DEFAULT_MAX_SINGLE_FILE_BYTE_SIZE = 0xA00000;
    public static final long DEFAULT_MAX_TOTAL_SIZE_CAP = 0xC800000L;
    public static final int DEFAULT_MAX_HISTORY_DAYS = 7;
    public static final int DEFAULT_MAX_FILE_AMOUNT_PER_DAY = 3;
    public static final String LOG_CHARSET = "utf-8";
    private static final String DIR_NAME = "logs" + File.separator + "csp";
    private static final String USER_HOME = "user.home";
    private static boolean logNameUsePid = false;
    private static String logBaseDir;
    private static int maxSingleFileSize;
    private static long maxTotalSizeCap;
    private static int maxTotalFileAmount;
    private static int maxFileAmountPerDay;
    private static long maxHistoryDays;

    private static void init() {
        int maxFileAmountPerDayParsed;
        long maxTotalCapParsed;
        File dir;
        String logDir = System.getProperty(LOG_DIR);
        if (logDir == null || logDir.isEmpty()) {
            logDir = System.getProperty(USER_HOME);
            logDir = AgwLogBase.addSeparator(logDir) + DIR_NAME + File.separator;
        }
        if (!(dir = new File(logDir = AgwLogBase.addSeparator(logDir))).exists() && !dir.mkdirs()) {
            System.err.println("ERROR: create log base dir error: " + logDir);
        }
        logBaseDir = logDir;
        System.out.println("INFO: AHAS AGW log base dir is: " + logBaseDir);
        String usePid = System.getProperty(LOG_NAME_USE_PID, "");
        logNameUsePid = "true".equalsIgnoreCase(usePid);
        long maxSingleFileSizeParsed = AgwLogBase.parseSizeBytes(System.getProperty(LOG_MAX_SINGLE_FILE_SIZE_PROP_KEY));
        if (maxSingleFileSizeParsed > 0L) {
            maxSingleFileSize = (int)maxSingleFileSizeParsed;
        }
        if ((maxTotalCapParsed = AgwLogBase.parseSizeBytes(System.getProperty(LOG_MAX_TOTAL_SIZE_CAP_PROP_KEY))) > 0L) {
            maxTotalSizeCap = maxTotalCapParsed;
        }
        maxTotalFileAmount = (int)Math.ceil(1.0 * (double)maxTotalSizeCap / (double)maxSingleFileSize);
        int maxHistoryDaysParsed = AgwLogBase.parsePositiveIntOrDefault(System.getProperty(LOG_MAX_HISTORY_PROP_KEY), 7);
        if (maxHistoryDaysParsed > 0) {
            maxHistoryDays = maxHistoryDaysParsed;
        }
        if ((maxFileAmountPerDayParsed = AgwLogBase.parsePositiveIntOrDefault(System.getProperty(LOG_MAX_FILE_AMOUNT_PER_DAY_PROP_KEY), 3)) > 0) {
            maxFileAmountPerDay = maxFileAmountPerDayParsed;
        }
        System.out.printf("INFO: AHAS AGW logNameWithPid=%s, maxSingleFileSize=%d, maxTotalFileAmount=%d, maxHistoryDays=%d%n", logNameUsePid, maxSingleFileSize, maxTotalFileAmount, maxHistoryDays);
    }

    public static boolean isLogNameUsePid() {
        return logNameUsePid;
    }

    private static String addSeparator(String logDir) {
        if (!logDir.endsWith(File.separator)) {
            logDir = logDir + File.separator;
        }
        return logDir;
    }

    protected static void log(Logger logger, Handler handler, Level level, String detail, Object ... params) {
        if (logger == null || detail == null) {
            return;
        }
        AgwLoggerUtils.disableOtherHandlers(logger, handler);
        if (params.length == 0) {
            logger.log(level, detail);
        } else {
            logger.log(level, detail, params);
        }
    }

    protected static void log(Logger logger, Handler handler, Level level, String detail, Throwable throwable) {
        if (logger == null || detail == null) {
            return;
        }
        AgwLoggerUtils.disableOtherHandlers(logger, handler);
        logger.log(level, detail, throwable);
    }

    public static String getLogBaseDir() {
        return logBaseDir;
    }

    public static int getMaxSingleFileSize() {
        return maxSingleFileSize;
    }

    public static long getMaxTotalSizeCap() {
        return maxTotalSizeCap;
    }

    public static long getMaxHistoryDays() {
        return maxHistoryDays;
    }

    public static int getMaxTotalFileAmount() {
        return maxTotalFileAmount;
    }

    public static int getMaxFileAmountPerDay() {
        return maxFileAmountPerDay;
    }

    protected static Handler makeLogger(String logName, Logger julLogger) {
        AgwLogFormatter formatter = new AgwLogFormatter();
        AgwDateFileLogHandler handler = null;
        try {
            handler = new AgwDateFileLogHandler(logName, AgwLogBase.getMaxSingleFileSize(), AgwLogBase.getMaxFileAmountPerDay(), true);
            ((Handler)handler).setFormatter(formatter);
            handler.setEncoding(LOG_CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (handler != null) {
            AgwLoggerUtils.disableOtherHandlers(julLogger, handler);
        }
        julLogger.setLevel(Level.INFO);
        return handler;
    }

    private static int parsePositiveIntOrDefault(String key, int defaultValue) {
        try {
            if (key == null || key.isEmpty()) {
                return defaultValue;
            }
            int v = Integer.parseInt(key);
            if (v <= 0) {
                return defaultValue;
            }
            return v;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static long parseSizeBytes(String sizeStr) {
        if (sizeStr == null || sizeStr.isEmpty()) {
            return 0L;
        }
        long base = 1L;
        if (sizeStr.endsWith("MB") || sizeStr.endsWith("mb")) {
            base = 0x100000L;
            sizeStr = sizeStr.substring(0, sizeStr.length() - 2);
        } else if (sizeStr.endsWith("M") || sizeStr.endsWith("m")) {
            base = 0x100000L;
            sizeStr = sizeStr.substring(0, sizeStr.length() - 1);
        } else if (sizeStr.endsWith("G") || sizeStr.endsWith("g")) {
            base = 0x40000000L;
            sizeStr = sizeStr.substring(0, sizeStr.length() - 1);
        } else if (sizeStr.endsWith("GB") || sizeStr.endsWith("gb")) {
            base = 0x40000000L;
            sizeStr = sizeStr.substring(0, sizeStr.length() - 2);
        } else if (sizeStr.endsWith("KB") || sizeStr.endsWith("kb")) {
            base = 1024L;
            sizeStr = sizeStr.substring(0, sizeStr.length() - 2);
        }
        try {
            return base * Long.parseLong(sizeStr);
        }
        catch (Exception ex) {
            System.err.println("Failed to parse log file size: " + sizeStr + ", using default");
            return 0L;
        }
    }

    static {
        maxSingleFileSize = 0xA00000;
        maxTotalSizeCap = 0xC800000L;
        maxFileAmountPerDay = 3;
        maxHistoryDays = 7L;
        try {
            AgwLogBase.init();
        }
        catch (Throwable t) {
            System.err.println("Failed to initialize AHAS agw logger config");
            t.printStackTrace();
        }
    }
}

