/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.misc;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;

public class IpUtil {
    private static String dockerBridgeName = "docker0";
    private static String dockerInetIp = "172.17.0.1";
    private static String ip = IpUtil.getIp();
    private static String address = IpUtil.getAddress();

    public static String getIp() {
        if (ip != null) {
            return ip;
        }
        ArrayList<String> ips = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress instanceof Inet6Address || dockerBridgeName.equals(networkInterface.getName())) continue;
                    ips.add(inetAddress.getHostAddress());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ips != null && ips.size() > 0) {
            ip = (String)ips.get(0);
        }
        return ip;
    }

    public static String getAddress() {
        if (address == null) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                address = addr.getHostName();
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        return address;
    }

    public static long ipToLong(String strIp) {
        String[] ip = strIp.split("\\.");
        return (Long.parseLong(ip[0]) << 24) + (Long.parseLong(ip[1]) << 16) + (Long.parseLong(ip[2]) << 8) + Long.parseLong(ip[3]);
    }

    public static String longToIP(long longIp) {
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(longIp >>> 24));
        sb.append(".");
        sb.append(String.valueOf((longIp & 0xFFFFFFL) >>> 16));
        sb.append(".");
        sb.append(String.valueOf((longIp & 0xFFFFL) >>> 8));
        sb.append(".");
        sb.append(String.valueOf(longIp & 0xFFL));
        return sb.toString();
    }
}

