/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.thread;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.thread.NamedThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ThreadPoolManager {
    private static ThreadPoolManager instance = new ThreadPoolManager();
    private ThreadPoolExecutor serverDataProcessPool;
    private ThreadPoolExecutor serverTopologyPool;
    private ThreadPoolExecutor serverTopologyHeartbeatPool;
    private ThreadPoolExecutor serverSentinelPool;
    private ThreadPoolExecutor serverSentinelHeartbeatPool;
    private ThreadPoolExecutor switchClientRequestProcessorPool;
    private ThreadPoolExecutor switchHeartbeatProcessorPool;
    private ThreadPoolExecutor clientPool;
    private final AtomicBoolean serverDataProcessPoolInitialized = new AtomicBoolean();
    private final AtomicBoolean serverTopologyPoolInitialized = new AtomicBoolean();
    private final AtomicBoolean serverTopologyHeartbeatPoolInitialized = new AtomicBoolean();
    private final AtomicBoolean serverSentinelPoolInitialized = new AtomicBoolean();
    private final AtomicBoolean serverSentinelHeartbeatPoolInitialized = new AtomicBoolean();
    private final AtomicBoolean switchClientRequestProcessorPoolInitialized = new AtomicBoolean();
    private final AtomicBoolean switchHeartbeatProcessorPoolInitialized = new AtomicBoolean();
    private final AtomicBoolean clientPoolInitialized = new AtomicBoolean();

    private ThreadPoolManager() {
    }

    public static ThreadPoolManager getInstance() {
        return instance;
    }

    private void initServerDataProcessThreadPool() {
        int coreSize = 80;
        int maxSize = 200;
        long keepAliveTime = 30L;
        NamedThreadFactory threadFactory = new NamedThreadFactory("AgwBizDataProcessProcessor - DEFAULT");
        this.serverDataProcessPool = new ThreadPoolExecutor(coreSize, maxSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(512), threadFactory);
    }

    private void initServerTopologyThreadPool() {
        int coreSize = 75;
        int maxSize = 150;
        long keepAliveTime = 30L;
        NamedThreadFactory threadFactory = new NamedThreadFactory("AgwBizTopologyProcessor");
        this.serverTopologyPool = new ThreadPoolExecutor(coreSize, maxSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(600), threadFactory);
    }

    private void initServerTopologyHeartbeatThreadPool() {
        int coreSize = 75;
        int maxSize = 150;
        long keepAliveTime = 30L;
        NamedThreadFactory threadFactory = new NamedThreadFactory("AgwBizTopologyHeartBeatProcessor");
        this.serverTopologyHeartbeatPool = new ThreadPoolExecutor(coreSize, maxSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), threadFactory);
    }

    private void initServerSentinelThreadPool() {
        this.serverSentinelPool = new ThreadPoolExecutor(60, 120, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), new NamedThreadFactory("AgwBizSentinelClientRequestProcessor"));
    }

    private void initServerSentinelHeartbeatThreadPool() {
        this.serverSentinelHeartbeatPool = new ThreadPoolExecutor(75, 120, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), new NamedThreadFactory("AgwBizSentinelHeartbeatProcessor"));
    }

    private void initServerSwitchCommonThreadPool() {
        this.switchClientRequestProcessorPool = new ThreadPoolExecutor(60, 120, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), new NamedThreadFactory("AgwBizSwitchClientRequestProcessor"));
    }

    public ThreadPoolExecutor getServerDataProcessThreadPool() {
        if (this.serverDataProcessPoolInitialized.get()) {
            return this.serverDataProcessPool;
        }
        if (this.serverDataProcessPoolInitialized.compareAndSet(false, true)) {
            this.initServerDataProcessThreadPool();
            return this.serverDataProcessPool;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.serverDataProcessPool;
    }

    public ThreadPoolExecutor getServerTopologyThreadPool() {
        if (this.serverTopologyPoolInitialized.get()) {
            return this.serverTopologyPool;
        }
        if (this.serverTopologyPoolInitialized.compareAndSet(false, true)) {
            this.initServerTopologyThreadPool();
            return this.serverTopologyPool;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.serverTopologyPool;
    }

    public ThreadPoolExecutor getServerTopologyHeartbeatThreadPool() {
        if (this.serverTopologyHeartbeatPoolInitialized.get()) {
            return this.serverTopologyHeartbeatPool;
        }
        if (this.serverTopologyHeartbeatPoolInitialized.compareAndSet(false, true)) {
            this.initServerTopologyHeartbeatThreadPool();
            return this.serverTopologyHeartbeatPool;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.serverTopologyHeartbeatPool;
    }

    public ThreadPoolExecutor getServerSentinelThreadPool() {
        if (this.serverSentinelPoolInitialized.get()) {
            return this.serverSentinelPool;
        }
        if (this.serverSentinelPoolInitialized.compareAndSet(false, true)) {
            this.initServerSentinelThreadPool();
            return this.serverSentinelPool;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.serverSentinelPool;
    }

    public ThreadPoolExecutor getServerSentinelHeartbeatThreadPool() {
        if (this.serverSentinelHeartbeatPoolInitialized.get()) {
            return this.serverSentinelHeartbeatPool;
        }
        if (this.serverSentinelHeartbeatPoolInitialized.compareAndSet(false, true)) {
            this.initServerSentinelHeartbeatThreadPool();
            return this.serverSentinelHeartbeatPool;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.serverSentinelHeartbeatPool;
    }

    public ThreadPoolExecutor getServerSwitchCommonThreadPool() {
        if (this.switchClientRequestProcessorPoolInitialized.get()) {
            return this.switchClientRequestProcessorPool;
        }
        if (this.switchClientRequestProcessorPoolInitialized.compareAndSet(false, true)) {
            this.initServerSwitchCommonThreadPool();
            return this.switchClientRequestProcessorPool;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.switchClientRequestProcessorPool;
    }

    private void initClientThreadPool() {
        int coreSize = 2;
        int maxSize = 10;
        long keepAliveTime = 20L;
        NamedThreadFactory threadFactory = new NamedThreadFactory("AgwBizClientProcessor - DEFAULT");
        this.clientPool = new ThreadPoolExecutor(coreSize, maxSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(16), threadFactory);
    }

    public ThreadPoolExecutor getClientThreadPool() {
        if (this.clientPoolInitialized.get()) {
            return this.clientPool;
        }
        if (this.clientPoolInitialized.compareAndSet(false, true)) {
            this.initClientThreadPool();
            return this.clientPool;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.clientPool;
    }
}

