/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.client;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.client.ClientInfoService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.config.ConfigService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.client.AppTypeParser;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.component.AgwProductCode;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.config.DefaultConfigService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.config.PropertiesConfigProvider;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.exception.AhasClientException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.init.AhasInitFunc;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util.AppNameUtil;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util.ContainerUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractClientInfoService
implements ClientInfoService,
AhasInitFunc {
    public static final String PID_DELIMITER = "@";
    public static final int HOST_TYPE = 0;
    public static final int CONTAINER_TYPE = 1;
    public static final int DEFAULT_GATEWAY_PORT = 9527;
    private final PropertiesConfigProvider propertiesConfigProvider;
    protected String pid;
    protected String appName;
    protected volatile String appType;
    protected String ahasAppName;
    protected String type;
    protected List<String> ips;
    protected List<String> jvmArgs;
    protected String vpcId;
    protected String instanceId;
    protected String gatewayHost;
    protected int gatewayPort;
    protected String acmHost;
    protected String cid;
    protected String userId;
    protected String namespace;
    protected String hostname;
    protected String hostIp;
    protected String privateIp;
    protected int deviceType = -1;
    protected String tid;
    protected String env;
    protected String version;
    protected String extensionInfo;
    protected String license;
    protected ConfigService configService;
    protected AgwProductCode agwProductCode;
    protected int timeoutMs = 3000;
    protected int heartbeatRate = 8;

    protected AbstractClientInfoService() {
        this(null);
    }

    protected AbstractClientInfoService(AgwProductCode agwProductCode) {
        this(agwProductCode, null);
    }

    protected AbstractClientInfoService(AgwProductCode agwProductCode, PropertiesConfigProvider propertiesConfigProvider) {
        this.agwProductCode = agwProductCode;
        this.propertiesConfigProvider = propertiesConfigProvider;
    }

    @Override
    public void init(String type, ClassLoader classLoader) throws Exception {
        this.configService = new DefaultConfigService(this.propertiesConfigProvider).init(classLoader);
        this.type = type;
        this.initEnv();
        this.initPidAndHostName();
        this.init0();
    }

    abstract void init0() throws AhasClientException;

    private void initEnv() {
        this.env = this.configService.getProperty("ahas.env", "prod");
    }

    private void initPidAndHostName() {
        String processInfo = ManagementFactory.getRuntimeMXBean().getName();
        if (AbstractClientInfoService.isBlank(processInfo)) {
            return;
        }
        if (processInfo.indexOf(PID_DELIMITER) == -1) {
            return;
        }
        String[] split = processInfo.split(PID_DELIMITER);
        String processId = split[0];
        if (AbstractClientInfoService.isBlank(processId)) {
            return;
        }
        this.hostname = split[1];
        try {
            Integer.valueOf(processId);
            this.pid = processId;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public String getAppName() {
        if (this.appName != null) {
            return this.appName;
        }
        this.appName = AppNameUtil.getAppName();
        return this.appName;
    }

    @Override
    public String getAppType() {
        if (this.appType != null) {
            return this.appType;
        }
        this.appType = String.valueOf(AppTypeParser.parseAppType());
        return this.appType;
    }

    @Override
    public boolean updateAppType(int appType) {
        if (appType < 0) {
            return false;
        }
        String v = String.valueOf(appType);
        if (v.equals(this.appType)) {
            return false;
        }
        this.appType = v;
        return true;
    }

    @Override
    public String getAhasAppName() {
        if (this.ahasAppName != null) {
            return this.ahasAppName;
        }
        this.ahasAppName = AppNameUtil.getAhasAppName();
        return this.ahasAppName;
    }

    @Override
    public String getPid() {
        if (this.pid == null) {
            this.initPidAndHostName();
        }
        return this.pid;
    }

    @Override
    public String getHostname() {
        if (this.hostname == null) {
            this.initPidAndHostName();
        }
        return this.hostname;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public List<String> getIps() {
        if (this.ips != null && !this.ips.isEmpty()) {
            return this.ips;
        }
        this.ips = this.getAllIps();
        return this.ips;
    }

    @Override
    public String getExtensionInfo() {
        if (this.extensionInfo == null) {
            this.extensionInfo = this.configService.getExtensionInfo();
        }
        return this.extensionInfo;
    }

    @Override
    public Map<String, String> getSystemProperties() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        Properties properties = System.getProperties();
        for (String name : properties.stringPropertyNames()) {
            map.put(name, properties.getProperty(name));
        }
        return map;
    }

    @Override
    public List<String> getJvmArgs() {
        if (this.jvmArgs != null) {
            return this.jvmArgs;
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        this.jvmArgs = runtimeMXBean.getInputArguments();
        return this.jvmArgs;
    }

    @Override
    public String getAid() {
        return this.cid;
    }

    @Override
    public String setAid(String aid) {
        this.cid = aid;
        return this.cid;
    }

    @Override
    public String setUserId(String userId) {
        this.userId = userId;
        return userId;
    }

    @Override
    public String getNamespace() {
        if (this.namespace != null) {
            return this.namespace;
        }
        this.namespace = this.configService.getProperty("ahas.namespace", "default");
        return this.namespace;
    }

    @Override
    public int getDeviceType() {
        if (this.deviceType != -1) {
            return this.deviceType;
        }
        this.deviceType = ContainerUtil.isRunningInContainer() ? 1 : 0;
        return this.deviceType;
    }

    @Override
    public String getTid() {
        return this.tid;
    }

    @Override
    public void setTid(String tid) {
        this.tid = tid;
    }

    @Override
    public String getLicense() {
        if (this.license == null) {
            this.license = this.configService.getLicense();
        }
        return this.license;
    }

    @Override
    public String getAhasEnv() {
        return this.env;
    }

    protected List<String> getAllIps() {
        ArrayList<String> ipv6s = new ArrayList<String>();
        ArrayList<String> reservedIpv6s = new ArrayList<String>();
        ArrayList<String> ipv4s = new ArrayList<String>();
        ArrayList<String> reservedIpv4s = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if ("docker0".equals(networkInterface.getName()) || inetAddress.isLoopbackAddress()) continue;
                    if (inetAddress instanceof Inet6Address) {
                        if (this.isReservedAddress(inetAddress)) {
                            reservedIpv6s.add(inetAddress.getHostAddress());
                            continue;
                        }
                        ipv6s.add(inetAddress.getHostAddress());
                        continue;
                    }
                    if (this.isReservedAddress(inetAddress)) {
                        reservedIpv4s.add(inetAddress.getHostAddress());
                        continue;
                    }
                    ipv4s.add(inetAddress.getHostAddress());
                }
            }
        }
        catch (Exception interfaces) {
            // empty catch block
        }
        ArrayList<String> ipList = new ArrayList<String>(ipv4s);
        ipList.addAll(reservedIpv4s);
        ipList.addAll(ipv6s);
        ipList.addAll(reservedIpv6s);
        return ipList;
    }

    protected boolean isReservedAddress(InetAddress inetAddress) {
        return inetAddress.isAnyLocalAddress() || inetAddress.isLinkLocalAddress();
    }

    @Override
    public AgwProductCode getAgwProductCode() {
        return this.agwProductCode;
    }

    @Override
    public int getTimeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public int getHeartbeatRate() {
        String hbRateSec = this.configService.getProperty("ahas.heartbeat.rate.second");
        if (hbRateSec != null) {
            try {
                return Integer.parseInt(hbRateSec);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.heartbeatRate;
    }

    protected static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

