/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.client;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util.AppNameUtil;

public class AppTypeParser {
    public static final int APP_TYPE_GATEWAY = 1;
    public static final int APP_TYPE_ZUUL = 12;

    private static boolean isNotEmptyStr(String str) {
        return str != null && !str.isEmpty();
    }

    public static int parseAppType(ClassLoader classLoader) {
        Class<?> clazz2;
        if (classLoader == null) {
            classLoader = AppTypeParser.class.getClassLoader();
        }
        String appTypeInProp = System.getProperty("csp.sentinel.app.type");
        String appTypeInEnv = System.getenv(AppNameUtil.SENTINEL_APP_TYPE_ENV_KEY);
        if (AppTypeParser.isNotEmptyStr(appTypeInEnv) || AppTypeParser.isNotEmptyStr(appTypeInProp)) {
            return AppNameUtil.getAppType();
        }
        String scName = "org.springframework.cloud.gateway.config.GatewayAutoConfiguration";
        String zuulName = "org.springframework.cloud.netflix.zuul.ZuulFilterInitializer";
        try {
            clazz2 = classLoader.loadClass(scName);
            if (clazz2 != null) {
                return 1;
            }
        }
        catch (Throwable clazz2) {
            // empty catch block
        }
        try {
            clazz2 = classLoader.loadClass(zuulName);
            if (clazz2 != null) {
                return 12;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return AppNameUtil.getAppType();
    }

    public static int parseAppType() {
        return AppTypeParser.parseAppType(ClassLoader.getSystemClassLoader());
    }
}

