/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.client;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.client.AbstractClientInfoService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.component.AgwProductCode;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.config.PropertiesConfigProvider;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.exception.AhasClientException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util.AppNameUtil;
import java.util.List;
import java.util.Random;

public class ApsaraClientInfoService
extends AbstractClientInfoService {
    private static final String AHAS_APP_NAME = "ahas.app.name";

    public ApsaraClientInfoService(AgwProductCode agwProductCode) {
        super(agwProductCode);
    }

    public ApsaraClientInfoService(AgwProductCode agwProductCode, PropertiesConfigProvider propertiesConfigProvider) {
        super(agwProductCode, propertiesConfigProvider);
    }

    @Override
    void init0() throws AhasClientException {
        this.initVpcId();
        this.initEndpoint();
    }

    private void initVpcId() {
        if (this.vpcId == null) {
            this.vpcId = this.getLicense();
        }
    }

    private void initEndpoint() throws AhasClientException {
        String endPoint;
        String gatewayEndpoint = System.getProperty("ahas.gateway.address", "");
        if (ApsaraClientInfoService.isBlank(gatewayEndpoint)) {
            throw new AhasClientException("cannot get ahas gateway address");
        }
        Random random = new Random();
        if (gatewayEndpoint.contains(",")) {
            String[] endpoints = gatewayEndpoint.split(",");
            int idx = random.nextInt(endpoints.length);
            endPoint = endpoints[idx];
        } else {
            endPoint = gatewayEndpoint;
        }
        String[] split = endPoint.split(":");
        if (split.length != 2) {
            throw new AhasClientException("Ahas agent endpoint length error");
        }
        this.gatewayHost = split[0];
        try {
            this.gatewayPort = Integer.valueOf(split[1]);
        }
        catch (NumberFormatException e) {
            this.gatewayPort = 9527;
        }
    }

    @Override
    public String getVpcId() {
        return this.vpcId;
    }

    @Override
    public String getHostIp() {
        if (this.hostIp != null) {
            return this.hostIp;
        }
        this.hostIp = this.getPrivateIp();
        return this.hostIp;
    }

    @Override
    public String getAppName() {
        if (this.appName != null) {
            return this.appName;
        }
        String app = System.getenv(AHAS_APP_NAME);
        if (!ApsaraClientInfoService.isEmpty(app)) {
            this.appName = app;
            return this.appName;
        }
        return AppNameUtil.getAppName();
    }

    @Override
    public String getPrivateIp() {
        if (this.privateIp != null) {
            return this.privateIp;
        }
        List<String> ips = this.getIps();
        if (ips != null && ips.size() > 0) {
            this.privateIp = ips.get(0);
            return this.privateIp;
        }
        return null;
    }

    @Override
    public String getInstanceId() {
        if (this.instanceId != null) {
            return this.instanceId;
        }
        this.instanceId = this.getHostname();
        return this.instanceId;
    }

    @Override
    public String getVersion() {
        if (this.version == null) {
            this.version = AgwProductCode.SWITCH.equals((Object)this.agwProductCode) ? this.configService.getSwitchVersion() : this.configService.getVersion();
        }
        return this.version;
    }

    @Override
    public String getAcmEndpoint() {
        return this.acmHost;
    }

    @Override
    public String getGatewayHost() {
        return this.gatewayHost;
    }

    @Override
    public int getGatewayPort() {
        return this.gatewayPort;
    }

    @Override
    public String getUserId() {
        if (this.userId != null) {
            return this.userId;
        }
        return null;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public String getRegionId() {
        return null;
    }

    @Override
    public Integer getSentinalDisable() {
        return -1;
    }

    @Override
    public String getSwitchId() {
        return "";
    }
}

