/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.client;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.AgwStringUtil;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.client.AbstractClientInfoService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.client.UrlConstants;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.component.AgwProductCode;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.config.PropertiesConfigProvider;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.exception.AhasClientException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util.AppNameUtil;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util.VpcEcsUtil;
import java.util.List;

public class DefaultClientInfoService
extends AbstractClientInfoService {
    public static final String PUBLIC_REGION_ID = "cn-public";
    private boolean isPrivate;
    private String regionId;
    private Integer sentinelDisable = -1;
    private String switchId;

    public DefaultClientInfoService(AgwProductCode agwProductCode) {
        super(agwProductCode);
    }

    public DefaultClientInfoService(AgwProductCode agwProductCode, PropertiesConfigProvider propertiesConfigProvider) {
        super(agwProductCode, propertiesConfigProvider);
    }

    @Override
    public void init0() throws AhasClientException {
        this.initPrivate();
        this.initRegionId();
        this.initVpcId();
        this.initSwitchId();
        this.initEndpoint();
    }

    private void initRegionId() {
        if (this.regionId == null) {
            this.regionId = this.configService.getAhasRegionId();
        }
        if (this.regionId == null && this.isPrivate) {
            this.regionId = VpcEcsUtil.getRegionId();
        }
        if (this.regionId == null) {
            this.regionId = this.configService.getSAERegionId();
        }
        if (this.regionId == null) {
            this.regionId = PUBLIC_REGION_ID;
        }
    }

    private void initPrivate() {
        String uid = VpcEcsUtil.getUid();
        if (uid != null) {
            this.isPrivate = true;
            this.userId = uid;
        } else {
            this.isPrivate = false;
        }
    }

    private void initSwitchId() throws AhasClientException {
        if (this.isPrivate) {
            this.switchId = VpcEcsUtil.getSwitchId();
            return;
        }
        this.switchId = this.getLicense();
        if (this.switchId == null || this.switchId.length() == 0) {
            throw new AhasClientException("cannot get switch id");
        }
    }

    private void initVpcId() throws AhasClientException {
        if (this.isPrivate) {
            this.vpcId = VpcEcsUtil.getVpcId();
            return;
        }
        this.vpcId = this.getLicense();
        if (this.vpcId == null || this.vpcId.length() == 0) {
            throw new AhasClientException("Cannot get AHAS license (license is required in current environment)");
        }
    }

    private void initEndpoint() throws AhasClientException {
        String endpoint;
        if (!UrlConstants.AHAS_OPEN_VPC_REGION.contains(this.regionId)) {
            if (AgwStringUtil.isBlank(this.getLicense())) {
                throw new AhasClientException("Region [" + this.regionId + "] is not opened, " + "use public license to connect to public env", false);
            }
            this.regionId = PUBLIC_REGION_ID;
        }
        if (DefaultClientInfoService.isBlank(endpoint = UrlConstants.GATEWAY_MAP.get(this.env + "-" + this.regionId))) {
            throw new AhasClientException("No AHAS proxy endpoint available, env=" + this.env + ", regionId=" + this.regionId, false);
        }
        this.acmHost = UrlConstants.ACM_MAP.get(this.regionId);
        if (DefaultClientInfoService.isBlank(this.acmHost)) {
            throw new AhasClientException("Cannot get ACM endpoint, regionId: " + this.regionId, false);
        }
        String[] split = endpoint.split(":");
        if (split.length != 2) {
            throw new AhasClientException("AHAS proxy endpoint length error", false);
        }
        this.gatewayHost = split[0];
        try {
            this.gatewayPort = Integer.valueOf(split[1]);
        }
        catch (NumberFormatException e) {
            this.gatewayPort = 9527;
        }
    }

    @Override
    public String getVpcId() {
        return this.vpcId;
    }

    @Override
    public String getSwitchId() {
        return this.switchId;
    }

    @Override
    public String getHostIp() {
        if (this.hostIp != null) {
            return this.hostIp;
        }
        this.hostIp = this.isPrivate() ? VpcEcsUtil.getPrivateIpv4() : this.getPrivateIp();
        return this.hostIp;
    }

    @Override
    public String getPrivateIp() {
        if (this.privateIp != null) {
            return this.privateIp;
        }
        if (this.isPrivate() && this.getDeviceType() == 0) {
            this.privateIp = this.getHostIp();
            return this.privateIp;
        }
        List<String> ips = this.getIps();
        if (ips != null && ips.size() > 0) {
            this.privateIp = ips.get(0);
            return this.privateIp;
        }
        return null;
    }

    @Override
    public String getInstanceId() {
        if (this.instanceId != null) {
            return this.instanceId;
        }
        this.instanceId = this.isPrivate() ? VpcEcsUtil.getInstanceId() : this.getHostname();
        return this.instanceId;
    }

    @Override
    public Integer getSentinalDisable() {
        if (this.sentinelDisable != -1) {
            return this.sentinelDisable;
        }
        this.sentinelDisable = AppNameUtil.getSentinelDisable();
        return this.sentinelDisable;
    }

    @Override
    public String getUserId() {
        if (this.userId != null) {
            return this.userId;
        }
        if (this.isPrivate) {
            this.userId = VpcEcsUtil.getUid();
        }
        return this.userId;
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public String getAcmEndpoint() {
        return this.acmHost;
    }

    @Override
    public String getGatewayHost() {
        return this.gatewayHost;
    }

    @Override
    public int getGatewayPort() {
        return this.gatewayPort;
    }

    @Override
    public String getVersion() {
        if (this.version == null) {
            this.version = AgwProductCode.SWITCH.equals((Object)this.agwProductCode) ? this.configService.getSwitchVersion() : this.configService.getVersion();
        }
        return this.version;
    }

    @Override
    public String getRegionId() {
        return this.regionId;
    }
}

