/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.client;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.client.AbstractClientInfoService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.component.AgwProductCode;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.exception.AhasClientException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util.InnerHostUtil;
import java.util.List;

public class InnerClientInfoService
extends AbstractClientInfoService {
    private String regionId = "";

    public InnerClientInfoService(AgwProductCode agwProductCode) {
        super(agwProductCode);
    }

    @Override
    void init0() throws AhasClientException {
        this.initHostAndPid();
        this.initEndpoint();
    }

    private void initHostAndPid() throws AhasClientException {
        this.acmHost = InnerHostUtil.getAcmHost();
        if (InnerClientInfoService.isBlank(this.acmHost)) {
            throw new AhasClientException("AHAS acmHost is empty");
        }
        this.namespace = InnerHostUtil.getNamespace();
        if (InnerClientInfoService.isBlank(this.namespace)) {
            throw new AhasClientException("AHAS namespace is empty");
        }
        this.regionId = InnerHostUtil.getRegionId();
        if (InnerClientInfoService.isBlank(this.regionId)) {
            throw new AhasClientException("AHAS regionId is empty");
        }
        this.vpcId = this.namespace;
        this.license = this.getLicense();
        this.pid = "1";
    }

    private void initEndpoint() throws AhasClientException {
        String endpoint = InnerHostUtil.getProxyEndPoint();
        if (InnerClientInfoService.isBlank(endpoint)) {
            throw new AhasClientException("No AHAS proxy endpoint available, env=" + this.env + ", regionId=" + this.getRegionId());
        }
        String[] split = endpoint.split(":");
        if (split.length != 2) {
            throw new AhasClientException("AHAS proxy endpoint length error");
        }
        this.gatewayHost = split[0];
        try {
            this.gatewayPort = Integer.valueOf(split[1]);
        }
        catch (NumberFormatException e) {
            this.gatewayPort = 9527;
        }
        this.timeoutMs = InnerHostUtil.getTimeoutMs();
        this.heartbeatRate = InnerHostUtil.getHeartbeatRate();
    }

    @Override
    public String getVpcId() {
        return this.vpcId;
    }

    @Override
    public String getSwitchId() {
        return "";
    }

    @Override
    public String getHostIp() {
        if (this.hostIp != null) {
            return this.hostIp;
        }
        this.hostIp = this.getPrivateIp();
        return this.hostIp;
    }

    @Override
    public String getPrivateIp() {
        if (this.privateIp != null) {
            return this.privateIp;
        }
        List<String> ips = this.getIps();
        if (ips != null && ips.size() > 0) {
            this.privateIp = ips.get(0);
            return this.privateIp;
        }
        return null;
    }

    @Override
    public String getInstanceId() {
        if (this.instanceId != null) {
            return this.instanceId;
        }
        this.instanceId = this.getHostname();
        return this.instanceId;
    }

    @Override
    public String getVersion() {
        if (this.version == null) {
            this.version = AgwProductCode.SWITCH.equals((Object)this.agwProductCode) ? this.configService.getSwitchVersion() : this.configService.getVersion();
        }
        return this.version;
    }

    @Override
    public String getAcmEndpoint() {
        return this.acmHost;
    }

    @Override
    public String getGatewayHost() {
        return this.gatewayHost;
    }

    @Override
    public int getGatewayPort() {
        return this.gatewayPort;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public String getRegionId() {
        return this.regionId;
    }

    @Override
    public Integer getSentinalDisable() {
        return -1;
    }
}

