/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.component;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.component.AgwComponent;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.component.AgwComponentType;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.component.AgwProductCode;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.component.ApsaraAgwComponent;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.component.DefaultAgwComponent;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.component.InnerAgwComponent;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util.InnerHostUtil;

public class AgwComponentManager {
    private static volatile AgwComponent agwComponent;
    private static final String GATEWAY_TYPE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AgwComponent getAgwComponent(AgwProductCode agwProductCode) {
        if (agwComponent != null) return agwComponent;
        Class<AgwComponentManager> clazz = AgwComponentManager.class;
        synchronized (AgwComponentManager.class) {
            if (String.valueOf(AgwComponentType.PUBLIC_CLOUD.getType()).equals(GATEWAY_TYPE)) {
                agwComponent = new DefaultAgwComponent(agwProductCode);
            }
            if (String.valueOf(AgwComponentType.PRIVATE_CLOUD.getType()).equals(GATEWAY_TYPE)) {
                agwComponent = new ApsaraAgwComponent(agwProductCode);
            }
            if (!String.valueOf(AgwComponentType.INNER_CLOUD.getType()).equals(GATEWAY_TYPE)) return agwComponent;
            agwComponent = new InnerAgwComponent(agwProductCode);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return agwComponent;
        }
    }

    public static boolean isPublic() {
        return String.valueOf(AgwComponentType.PUBLIC_CLOUD.getType()).equals(System.getProperty("ahas.agw.type", String.valueOf(AgwComponentType.PUBLIC_CLOUD.getType())));
    }

    public static boolean isPrivate() {
        return String.valueOf(AgwComponentType.PRIVATE_CLOUD.getType()).equals(System.getProperty("ahas.agw.type"));
    }

    public static boolean isInner() {
        return String.valueOf(AgwComponentType.INNER_CLOUD.getType()).equals(System.getProperty("ahas.agw.type"));
    }

    static {
        InnerHostUtil.initAgwType();
        GATEWAY_TYPE = System.getProperty("ahas.agw.type", String.valueOf(AgwComponentType.PUBLIC_CLOUD.getType()));
    }
}

