/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.config;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.config.ConfigService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.config.PropertiesConfigProvider;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.exception.AhasClientException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util.AgentConfigFileHelper;
import java.util.Map;
import java.util.Properties;

public class DefaultConfigService
implements ConfigService {
    public static final String UNKNOWN = "unknown";
    private final Properties configs = new Properties();
    private final PropertiesConfigProvider propertiesConfigProvider;

    public DefaultConfigService() {
        this(null);
    }

    public DefaultConfigService(PropertiesConfigProvider propertiesConfigProvider) {
        this.propertiesConfigProvider = propertiesConfigProvider;
    }

    public ConfigService init(ClassLoader classLoader) throws AhasClientException {
        Properties p;
        Properties properties = AgentConfigFileHelper.loadVersionProperties(classLoader);
        if (properties != null) {
            this.configs.putAll((Map<?, ?>)properties);
        }
        if ((properties = AgentConfigFileHelper.loadConfigFile(classLoader)) != null) {
            this.configs.putAll((Map<?, ?>)properties);
        }
        if (this.propertiesConfigProvider != null && (p = this.propertiesConfigProvider.getConfig()) != null) {
            this.configs.putAll((Map<?, ?>)p);
        }
        return this;
    }

    @Override
    public String getLicense() {
        return this.getProperty("ahas.license");
    }

    @Override
    public boolean restrictedVpc() {
        String scope = this.getProperty("ahas.scope");
        return "r_vpc".equalsIgnoreCase(scope);
    }

    @Override
    public String getSAERegionId() {
        return this.getProperty("SAE_INSTANCE_REGION_ID");
    }

    @Override
    public String getAhasRegionId() {
        return this.getProperty("ahas.regionId");
    }

    @Override
    public String getVersion() {
        return this.getProperty("ahas.version", UNKNOWN);
    }

    @Override
    public String getExtensionInfo() {
        return this.getProperty("ahas.extensionInfo");
    }

    @Override
    public String getSwitchVersion() {
        return this.getProperty("ahas.switch.version", UNKNOWN);
    }

    @Override
    public String getBuildNumber() {
        return this.getProperty("ahas.build.number", UNKNOWN);
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.getPropertyFromSystemEnvironment(key);
        if (value != null) {
            return value;
        }
        value = this.getPropertyFromSystemProperties(key);
        if (value != null) {
            return value;
        }
        return this.configs.getProperty(key, defaultValue);
    }

    protected String getPropertyFromSystemProperties(String key) {
        return System.getProperty(key);
    }

    protected String getPropertyFromSystemEnvironment(String key) {
        String v = System.getenv(key);
        if (v != null) {
            return v;
        }
        String envKey = key.replace('.', '_').toUpperCase();
        return System.getenv(envKey);
    }
}

