/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.heartbeat;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.log.AgwLogger;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.client.ClientInfoService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.component.AgwComponent;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.heartbeat.HeartbeatService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.Request;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.Response;

public abstract class AbstractHeartbeatService
implements HeartbeatService {
    protected AgwComponent agwComponent;
    protected volatile String cachedAppType;

    public AbstractHeartbeatService(String name) {
    }

    @Override
    public void init(AgwComponent agwComponent) {
        this.agwComponent = agwComponent;
        this.cachedAppType = agwComponent.getClientInfoService().getAppType();
    }

    @Override
    public Response<String> sendHeartbeat() {
        ClientInfoService clientInfoService = this.agwComponent.getClientInfoService();
        String version = clientInfoService.getVersion();
        try {
            Request request = new Request(true);
            request.addHeader("uid", clientInfoService.getUserId());
            request.addHeader("v", version);
            this.addAppTypeToRequestIfNeeded(request);
            Response<String> response = this.invoke(request);
            return response;
        }
        catch (Exception e) {
            return Response.ofFailure(Response.Code.SERVER_ERROR, e.getMessage(), null);
        }
    }

    private void addAppTypeToRequestIfNeeded(Request request) {
        try {
            String curAppType = this.agwComponent.getClientInfoService().getAppType();
            if (this.cachedAppType == null) {
                return;
            }
            if (!this.cachedAppType.equals(curAppType)) {
                request.addHeader("appType", curAppType);
                this.cachedAppType = curAppType;
                AgwLogger.info("AppType change detected in HeartbeatService, newValue=" + curAppType, new Object[0]);
            }
        }
        catch (Exception ex) {
            AgwLogger.warn("Failed to addAppTypeToRequestIfNeeded", ex);
        }
    }

    abstract Response<String> invoke(Request var1);
}

