/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.transport;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.auth.api.AuthException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.client.bootstrap.outer.AgwClient;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.client.bootstrap.outer.ClientToServerAgwConfig;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.client.ClientInfoService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.transport.TransportService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.exception.AhasClientException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.transport.AgwRequestClientInvoker;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.AgwRequestHandler;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.AgwRequestInvoker;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.AgwRequestUri;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.DecoderException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.EncoderException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.Request;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.RequestInterceptor;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.Response;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.TimeoutException;

public abstract class AbstractTransportService
implements TransportService {
    protected static final int RETRY_COUNT = 3;
    protected ClientInfoService clientInfoService;
    protected final AgwClient agwClient = AgwClient.getInstance();
    protected AgwRequestInvoker agwRequestInvoker;
    protected RequestInterceptor requestInterceptor;

    @Override
    public void init(ClientInfoService clientInfoService) throws AhasClientException {
        this.clientInfoService = clientInfoService;
        this.initAgwClient();
        this.initRequestInvoker();
        this.connect();
    }

    private void initRequestInvoker() {
        this.agwRequestInvoker = new AgwRequestClientInvoker(this.agwClient);
        this.initRequestInterceptor();
        this.agwRequestInvoker.setRequestInterceptor(this.requestInterceptor);
    }

    @Override
    public void registerHandler(String handlerName, AgwRequestHandler handler) {
        handler.setRequestInterceptor(this.requestInterceptor);
        this.agwClient.addHandler(handlerName, handler);
    }

    abstract void initRequestInterceptor();

    abstract void connect() throws AhasClientException;

    @Override
    public <R> Response<R> invoke(AgwRequestUri uri, Request request, Class<?> clazz) {
        return this.invoke0(uri, request, this.agwRequestInvoker, clazz);
    }

    @Override
    public void destroy() {
        if (this.agwClient != null) {
            this.agwClient.destroy();
        }
    }

    private void initAgwClient() throws AhasClientException {
        if (this.clientInfoService.getPrivateIp() == null) {
            throw new AhasClientException("Cannot get local ip.");
        }
        String tag = this.clientInfoService.getType() + ":" + this.clientInfoService.getPrivateIp() + ":" + this.clientInfoService.getPid();
        ClientToServerAgwConfig agwConfig = new ClientToServerAgwConfig();
        agwConfig.setClientVpcId(this.clientInfoService.getVpcId()).setClientIp(this.clientInfoService.getHostIp()).setClientProcessFlag(tag).setAhasGatewayIp(this.clientInfoService.getGatewayHost()).setAhasGatewayPort(this.clientInfoService.getGatewayPort()).setOptionalTimeoutMs(3000);
        this.agwClient.init(agwConfig);
    }

    protected <R> Response<R> invoke0(AgwRequestUri uri, Request request, AgwRequestInvoker invoker, Class<?> clazz) {
        if (invoker == null) {
            return Response.ofFailure(Response.Code.UNINITIALIZED, "request invoker has not been initialized yet");
        }
        try {
            String userId = this.clientInfoService.getUserId();
            if (userId != null && userId != "") {
                request.addHeader("uid", userId);
            }
            request.addHeader("aid", this.clientInfoService.getAid());
            request.addHeader("pid", this.clientInfoService.getPid());
            request.addHeader("type", this.clientInfoService.getType());
            uri.setTimeoutMs(this.clientInfoService.getTimeoutMs());
            return invoker.invoke(uri, request, clazz);
        }
        catch (Exception e) {
            String message = "aid: " + this.clientInfoService.getAid() + ", msg: " + e.getMessage();
            if (e instanceof TimeoutException) {
                return Response.ofFailure(Response.Code.TIMEOUT, message);
            }
            if (e instanceof AuthException) {
                return Response.ofFailure(Response.Code.FORBIDDEN, message);
            }
            if (e instanceof EncoderException) {
                return Response.ofFailure(Response.Code.ENCODE_ERROR, message);
            }
            if (e instanceof DecoderException) {
                return Response.ofFailure(Response.Code.DECODE_ERROR, message);
            }
            return Response.ofFailure(Response.Code.SERVER_ERROR, message);
        }
    }
}

