/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.transport;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.auth.api.AuthUtil;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.exception.AhasClientException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.transport.AbstractTransportService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.transport.AgwRequestClientInvoker;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.AgwRequestUri;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.ClientAuthInterceptor;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.Request;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.Response;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.ServiceConstants;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.TimestampInterceptor;
import java.util.Map;

public class InnerTransportService
extends AbstractTransportService {
    @Override
    void initRequestInterceptor() {
        this.requestInterceptor = new TimestampInterceptor();
        ((TimestampInterceptor)this.requestInterceptor).setInterceptor(new ClientAuthInterceptor());
    }

    @Override
    void connect() throws AhasClientException {
        Request request = new Request(true);
        request.addParam("vpcId", this.clientInfoService.getVpcId()).addParam("ip", this.clientInfoService.getPrivateIp()).addParam("appName", this.clientInfoService.getAppName()).addParam("appType", this.clientInfoService.getAppType()).addParam("ahasAppName", this.clientInfoService.getAhasAppName()).addParam("pid", this.clientInfoService.getPid()).addParam("type", this.clientInfoService.getType()).addParam("namespace", this.clientInfoService.getNamespace()).addParam("deviceId", this.clientInfoService.getHostname()).addParam("deviceType", this.clientInfoService.getDeviceType() + "").addParam("hostIp", this.clientInfoService.getHostIp()).addParam("v", this.clientInfoService.getVersion()).addParam("ak", this.clientInfoService.getLicense());
        String extensionInfo = this.clientInfoService.getExtensionInfo();
        if (extensionInfo != null) {
            request.addParam("extensionInfo", extensionInfo);
        }
        AgwRequestUri requestUri = new AgwRequestUri(this.getServiceConstants());
        AgwRequestClientInvoker clientInvoker = new AgwRequestClientInvoker(this.agwClient);
        int count = 0;
        while (true) {
            AhasClientException panicException;
            ++count;
            try {
                Response<Map<String, String>> response = this.invoke0(requestUri, request, clientInvoker, Map.class);
                this.handleConnectResponse(response);
                panicException = null;
            }
            catch (AhasClientException e) {
                panicException = e;
            }
            if (panicException == null) break;
            if (count >= 3) {
                throw panicException;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void handleConnectResponse(Response<Map<String, String>> response) throws AhasClientException {
        if (!response.isSuccess()) {
            throw new AhasClientException("[HandleConnectResponse] Connect server failed, " + response.getError());
        }
        Map<String, String> result = response.getResult();
        this.clientInfoService.setAid(result.get("aid"));
        String uid = result.get("uid");
        if (uid == null || uid.length() == 0) {
            throw new AhasClientException("[HandleConnectResponse] Uid is empty");
        }
        this.clientInfoService.setUserId(uid);
        String tid = result.get("tid");
        this.clientInfoService.setTid(tid);
        try {
            String accessKey = result.get("ak");
            String secretKey = result.get("sk");
            AuthUtil.recordKeyToFile(accessKey, secretKey);
        }
        catch (Exception e) {
            throw new AhasClientException("Record ak and sk exception", e);
        }
    }

    private ServiceConstants getServiceConstants() throws AhasClientException {
        Enum serviceConstant;
        switch (this.clientInfoService.getAgwProductCode()) {
            case SENTINEL: {
                serviceConstant = ServiceConstants.Sentinel.CONNECT;
                break;
            }
            case SWITCH: {
                serviceConstant = ServiceConstants.Switch.CONNECT;
                break;
            }
            default: {
                throw new AhasClientException("not find client productCode");
            }
        }
        return serviceConstant;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }
}

