/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.exception.AhasClientException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util.EmbeddedJarUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.util.Properties;

public class AgentConfigFileHelper {
    public static final String configFileName = "ahas-java-agent.config";
    public static final String VERSION_CONFIG = "version.properties";
    public static final int CONFIG_MAX_SIZE = 0x100000;

    public static Properties loadConfigFile(ClassLoader classLoader) throws AhasClientException {
        String configFile = AgentConfigFileHelper.getConfigFile(classLoader);
        if (configFile == null) {
            return null;
        }
        File file = new File(configFile);
        if (!file.exists()) {
            return null;
        }
        if (file.length() > 0x100000L) {
            throw new AhasClientException("config file is incorrect.");
        }
        try {
            return AgentConfigFileHelper.load(file);
        }
        catch (Exception e) {
            throw new AhasClientException(e);
        }
    }

    private static Properties load(File file) throws Exception {
        Properties properties = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            properties.load(is);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    private static String getConfigFile(ClassLoader classLoader) {
        File homeDirectory = AgentConfigFileHelper.findHomeDirectory(classLoader);
        if (homeDirectory == null) {
            return null;
        }
        return homeDirectory.getAbsolutePath() + "/" + configFileName;
    }

    private static File findHomeDirectory(ClassLoader classLoader) {
        File homeDir = AgentConfigFileHelper.findHomeDirectoryFromProperty();
        if (homeDir != null) {
            return homeDir;
        }
        homeDir = AgentConfigFileHelper.findHomeDirectoryFromEnvironmentVariable();
        if (homeDir != null) {
            return homeDir;
        }
        return AgentConfigFileHelper.getAgentJarDirectory(classLoader);
    }

    public static File getAgentJarDirectory(ClassLoader classLoader) {
        File file;
        URL agentJarUrl = AgentConfigFileHelper.getAgentJarUrl(classLoader);
        if (agentJarUrl != null && (file = new File(AgentConfigFileHelper.getAgentJarFileName(agentJarUrl))).exists()) {
            return file.getParentFile();
        }
        return null;
    }

    private static URL getAgentJarUrl(ClassLoader classLoader) {
        try {
            if (classLoader == null) {
                classLoader = AgentConfigFileHelper.class.getClassLoader();
                return classLoader.getClass().getProtectionDomain().getCodeSource().getLocation();
            }
            CodeSource codeSource = AgentConfigFileHelper.class.getProtectionDomain().getCodeSource();
            if (codeSource == null) {
                return classLoader.getClass().getProtectionDomain().getCodeSource().getLocation();
            }
            return codeSource.getLocation();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getAgentJarFileName(URL agentJarUrl) {
        if (agentJarUrl == null) {
            return null;
        }
        try {
            return URLDecoder.decode(agentJarUrl.getFile().replace("+", "%2B"), "UTF-8");
        }
        catch (IOException e) {
            return null;
        }
    }

    private static File findHomeDirectoryFromProperty() {
        File homeDir;
        String filePath = System.getProperty("ahas.home");
        if (filePath != null && (homeDir = new File(filePath)).exists()) {
            return homeDir;
        }
        return null;
    }

    private static File findHomeDirectoryFromEnvironmentVariable() {
        File homeDir;
        String filePath = System.getenv("AHAS_HOME");
        if (filePath != null && (homeDir = new File(filePath)).exists()) {
            return homeDir;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadVersionProperties(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = EmbeddedJarUtil.class.getClassLoader();
        }
        if (classLoader == null) {
            return null;
        }
        InputStream jarStream = classLoader.getResourceAsStream(VERSION_CONFIG);
        if (jarStream == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(jarStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception e) {
            Properties properties3 = properties;
            return properties3;
        }
        finally {
            try {
                jarStream.close();
            }
            catch (Exception exception) {}
        }
    }
}

