/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util;

import java.io.File;

public final class AppNameUtil {
    public static final int APP_TYPE_COMMON = 0;
    public static final String AHAS_SENTINEL_ENABLE = "true";
    public static final String AHAS_SENTINEL_DISABLE = "false";
    public static final int AHAS_SENTINEL_ENABLE_VALUE = 0;
    public static final int AHAS_SENTINEL_DISABLE_VALUE = 1;
    public static final String APP_TYPE_PROP_KEY = "csp.sentinel.app.type";
    public static final String PROJECT_NAME_PROP_KEY = "project.name";
    public static final String APP_NAME_PROP_KEY = "csp.sentinel.app.name";
    public static final String AHAS_APP_NAME = "ahas.project.name";
    public static final String AHAS_SENTINEL_ENABLE_ARG = "ahas.sentinel.enable";
    public static final String SENTINEL_APP_TYPE_ENV_KEY = AppNameUtil.toEnvKey("csp.sentinel.app.type");
    public static final String SENTINEL_APP_NAME_ENV_KEY = AppNameUtil.toEnvKey("csp.sentinel.app.name");
    public static final String SUN_JAVA_COMMAND = "sun.java.command";
    private static final String JAR_SUFFIX_LOWER = ".jar";
    private static final String JAR_SUFFIX_UPPER = ".JAR";
    private static String appName;
    private static String ahasAppName;
    private static int appType;
    private static int sentinelDisableFlag;

    private AppNameUtil() {
    }

    public static void resolveAppType() {
        try {
            String type = System.getenv(SENTINEL_APP_TYPE_ENV_KEY);
            if ((type == null || type.isEmpty()) && (type = System.getProperty(APP_TYPE_PROP_KEY)) == null) {
                appType = 0;
                return;
            }
            appType = Integer.parseInt(type);
            if (appType < 0) {
                appType = 0;
            }
        }
        catch (Exception ex) {
            appType = 0;
        }
    }

    public static void resolveAhasAppName() {
        String app = System.getProperty(AHAS_APP_NAME);
        if (!AppNameUtil.isEmpty(app)) {
            ahasAppName = app;
        }
    }

    public static void resolveAppName() {
        String separator;
        String app = System.getenv(SENTINEL_APP_NAME_ENV_KEY);
        if (!AppNameUtil.isEmpty(app)) {
            appName = app;
            return;
        }
        app = System.getProperty(APP_NAME_PROP_KEY);
        if (!AppNameUtil.isEmpty(app)) {
            appName = app;
            return;
        }
        app = System.getProperty(PROJECT_NAME_PROP_KEY);
        if (!AppNameUtil.isEmpty(app)) {
            appName = app;
            return;
        }
        String command = System.getProperty(SUN_JAVA_COMMAND);
        if (AppNameUtil.isEmpty(command)) {
            return;
        }
        if ((command = command.split("\\s")[0]).contains(separator = File.separator)) {
            String[] strs = "\\".equals(separator) ? command.split("\\\\") : command.split(separator);
            command = strs[strs.length - 1];
        }
        if (command.endsWith(JAR_SUFFIX_LOWER) || command.endsWith(JAR_SUFFIX_UPPER)) {
            command = command.substring(0, command.length() - 4);
        }
        appName = command;
    }

    public static void resolveSentinelEnable() {
        try {
            String enable = System.getProperty(AHAS_SENTINEL_ENABLE_ARG, String.valueOf(AHAS_SENTINEL_ENABLE));
            if (enable.equalsIgnoreCase(AHAS_SENTINEL_DISABLE)) {
                sentinelDisableFlag = 1;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        sentinelDisableFlag = 0;
    }

    public static String getAppName() {
        return appName;
    }

    public static String getAhasAppName() {
        return ahasAppName;
    }

    public static int getAppType() {
        return appType;
    }

    public static int getSentinelDisable() {
        return sentinelDisableFlag;
    }

    private static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    private static String toEnvKey(String propKey) {
        return propKey.toUpperCase().replace('.', '_');
    }

    static {
        AppNameUtil.resolveAppName();
        AppNameUtil.resolveAppType();
        AppNameUtil.resolveAhasAppName();
        AppNameUtil.resolveSentinelEnable();
    }
}

