/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public final class ConfigFileUtil {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    public static final String CLASSPATH_FILE_FLAG = "classpath:";

    public static Properties loadProperties(String fileName) {
        if (fileName != null && !fileName.isEmpty()) {
            if (ConfigFileUtil.absolutePathStart(fileName)) {
                return ConfigFileUtil.loadPropertiesFromAbsoluteFile(fileName);
            }
            if (fileName.startsWith(CLASSPATH_FILE_FLAG)) {
                return ConfigFileUtil.loadPropertiesFromClasspathFile(fileName);
            }
            return ConfigFileUtil.loadPropertiesFromRelativeFile(fileName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFromAbsoluteFile(String fileName) {
        Properties properties = null;
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                return null;
            }
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), DEFAULT_CHARSET));
                properties = new Properties();
                properties.load(bufferedReader);
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return properties;
    }

    private static boolean absolutePathStart(String path) {
        File[] files;
        for (File file : files = File.listRoots()) {
            if (!path.startsWith(file.getPath())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFromClasspathFile(String fileName) {
        fileName = fileName.substring(CLASSPATH_FILE_FLAG.length()).trim();
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            Enumeration<URL> urls = ConfigFileUtil.getClassLoader().getResources(fileName);
            while (urls.hasMoreElements()) {
                list.add(urls.nextElement());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (list.isEmpty()) {
            return null;
        }
        Properties properties = new Properties();
        for (URL url : list) {
            try {
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(url.openStream(), ConfigFileUtil.getCharset()));
                    Properties p = new Properties();
                    p.load(bufferedReader);
                    properties.putAll((Map<?, ?>)p);
                }
                finally {
                    if (bufferedReader == null) continue;
                    bufferedReader.close();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return properties;
    }

    private static Properties loadPropertiesFromRelativeFile(String fileName) {
        String userDir = System.getProperty("user.dir");
        String realFilePath = ConfigFileUtil.addSeparator(userDir) + fileName;
        return ConfigFileUtil.loadPropertiesFromAbsoluteFile(realFilePath);
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ConfigFileUtil.class.getClassLoader();
        }
        return classLoader;
    }

    private static Charset getCharset() {
        return Charset.forName("UTF-8");
    }

    public static String addSeparator(String dir) {
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        return dir;
    }

    private ConfigFileUtil() {
    }
}

