/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util;

import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.TypeReference;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.parser.Feature;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.component.AgwComponentType;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class InnerHostUtil {
    private static String ACM_HOST = null;
    private static final String ADDRESS_URL = "jmenv.tbsite.net";
    private static final Random RANDOM = new Random();
    private static final int RETRY_TIMES = Integer.valueOf(System.getProperty("ahas.inner.diamond.retry", "3"));
    private static final int CONNECT_TIME_OUT = Integer.valueOf(System.getProperty("ahas.inner.diamond.connect.timeout", "1000"));
    private static final int READ_TIME_OUT = Integer.valueOf(System.getProperty("ahas.inner.diamond.read.timeout", "3000"));
    private static Map<String, String> AHAS_INNER_CONFIG_MAP;

    public static String getAcmHost() {
        return ACM_HOST;
    }

    public static String getRegionId() {
        return AHAS_INNER_CONFIG_MAP.get("region");
    }

    public static String getNamespace() {
        return AHAS_INNER_CONFIG_MAP.get("namespace");
    }

    public static String getProxyEndPoint() {
        return AHAS_INNER_CONFIG_MAP.get("endpoint");
    }

    public static int getTimeoutMs() {
        int defaultTimeoutMs = 3000;
        String timeoutMs = AHAS_INNER_CONFIG_MAP.get("timeout");
        try {
            return timeoutMs == null ? 3000 : Integer.valueOf(timeoutMs);
        }
        catch (Exception ex) {
            return 3000;
        }
    }

    public static int getHeartbeatRate() {
        int defaultHbRateSec = 15;
        try {
            String heartbeatRate = AHAS_INNER_CONFIG_MAP.get("heartbeat");
            return heartbeatRate == null ? 15 : Integer.valueOf(heartbeatRate);
        }
        catch (Exception ex) {
            return 15;
        }
    }

    public static void initAgwType() {
        try {
            if (System.getProperty("ahas.agw.type") != null) {
                return;
            }
            if (System.getProperty("ahas.license") != null) {
                return;
            }
            String env = InnerHostUtil.getRemoteMessage("http://" + ACM_HOST + ":8080/env");
            if (env == null) {
                return;
            }
            System.setProperty("ahas.agw.type", String.valueOf(AgwComponentType.INNER_CLOUD.getType()));
            System.out.println("AHAS init agw type is inner cloud");
        }
        catch (Exception e) {
            System.out.println("AHAS init agw type exception" + e.getMessage());
        }
    }

    public static void initAhasInnerConfig() {
        String config = InnerHostUtil.getConfig("ahas.cn-inner.config", "ahas-proxy");
        if (config == null || config.isEmpty()) {
            System.setProperty("ahas.inner.agw.disable", "1");
            return;
        }
        AHAS_INNER_CONFIG_MAP = JSON.parseObject(config, new TypeReference<Map<String, String>>(){}, new Feature[0]);
    }

    private static String getConfig(String dataId, String groupId) {
        String diamondServer = InnerHostUtil.getRandomDiamondServer();
        String config = null;
        if (diamondServer != null && !diamondServer.isEmpty()) {
            config = InnerHostUtil.getRemoteMessage("http://" + diamondServer + ":8080/diamond-server/config.co?dataId=" + dataId + "&group=" + groupId);
        }
        return config;
    }

    private static String getRandomDiamondServer() {
        String diamondServerStr = InnerHostUtil.getRemoteMessage("http://" + ACM_HOST + ":8080/diamond-server/diamond");
        List<Object> diamondServerList = new ArrayList();
        if (diamondServerStr != null && !diamondServerStr.isEmpty()) {
            diamondServerList = Arrays.asList(diamondServerStr.split("\n"));
        }
        if (diamondServerList.isEmpty()) {
            return null;
        }
        return (String)diamondServerList.get(RANDOM.nextInt(diamondServerList.size()));
    }

    public static String getLicense() {
        return "license-inner";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRemoteMessage(String urlValue) {
        boolean result = false;
        int times = 0;
        while (!result && times < RETRY_TIMES) {
            String string;
            HttpURLConnection conn = null;
            BufferedReader in = null;
            try {
                String inputLine;
                URL url = new URL(urlValue);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(CONNECT_TIME_OUT);
                conn.setReadTimeout(READ_TIME_OUT);
                conn.setInstanceFollowRedirects(true);
                in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                if (conn.getResponseCode() != 200) {
                    String string2 = null;
                    return string2;
                }
                int mark = 0;
                StringBuilder content = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    content.append(inputLine).append("\n");
                    if (mark >= 1) {
                        content.append(inputLine).append("\n");
                    }
                    if (!"".equals(inputLine.trim())) continue;
                    ++mark;
                }
                result = true;
                string = content.toString().trim();
            }
            catch (Exception exception) {}
            return string;
            continue;
            finally {
                ++times;
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (conn != null) {
                        conn.disconnect();
                    }
                    if (result) continue;
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    static {
        ACM_HOST = System.getProperty("ahas.address.server.domain");
        if (ACM_HOST == null || ACM_HOST.isEmpty()) {
            ACM_HOST = System.getProperty("address.server.domain", ADDRESS_URL);
            System.setProperty("ahas.address.server.domain", ACM_HOST);
        }
        AHAS_INNER_CONFIG_MAP = new HashMap<String, String>();
    }
}

