/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.log.AgwLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public class VpcEcsUtil {
    private static final int STATUS_OK = 200;
    private static final String vpcMetaUrl = System.getProperty("ahas.vpc.url", "http://100.100.100.200/latest/meta-data/");
    private static final boolean logEnabled = "true".equalsIgnoreCase(System.getenv("AHAS_ALIYUN_META_LOG_ENABLED"));

    public static boolean isVpcEnv() {
        return VpcEcsUtil.getRemoteMessage(vpcMetaUrl) != null;
    }

    public static String getVpcId() {
        return VpcEcsUtil.getRemoteMessage(vpcMetaUrl + "vpc-id");
    }

    public static String getSwitchId() {
        return VpcEcsUtil.getRemoteMessage(vpcMetaUrl + "vswitch-id");
    }

    public static String getPrivateIpv4() {
        return VpcEcsUtil.getRemoteMessage(vpcMetaUrl + "private-ipv4");
    }

    public static String getInstanceId() {
        return VpcEcsUtil.getRemoteMessage(vpcMetaUrl + "instance-id");
    }

    public static String getRegionId() {
        return VpcEcsUtil.getRemoteMessage(vpcMetaUrl + "region-id");
    }

    public static String getUid() {
        return VpcEcsUtil.getRemoteMessage(vpcMetaUrl + "owner-account-id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRemoteMessage(String urlValue) {
        HttpURLConnection conn = null;
        BufferedReader in = null;
        try {
            String inputLine;
            URL url = new URL(urlValue);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(500);
            conn.setReadTimeout(1000);
            conn.setInstanceFollowRedirects(true);
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder content = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            String result = content.toString();
            int statusCode = conn.getResponseCode();
            if (statusCode != 200) {
                AgwLogger.warn("Aliyun metadata result not OK, URL=" + urlValue + ", statusCode=" + statusCode + ", result=" + result, new Object[0]);
                String string = null;
                return string;
            }
            if (logEnabled) {
                AgwLogger.info("Aliyun metadata request URL=" + urlValue + ", statusCode=" + statusCode + ", result=" + result, new Object[0]);
            }
            String string = result;
            return string;
        }
        catch (Exception e) {
            if (logEnabled) {
                System.err.println("Failed to request Aliyun metadata URL: " + urlValue);
                AgwLogger.warn("Failed to request Aliyun metadata URL: " + urlValue, e);
            }
            String string = null;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

