/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.auth.api.AuthException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.client.api.handler.AgwHandler;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.EncoderException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.InvalidTimestampException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.JsonEncoder;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.Request;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.RequestHandler;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.RequestInterceptor;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.RequestJsonDecoder;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.Response;

public abstract class AgwRequestHandler<R>
implements RequestHandler,
AgwHandler {
    private RequestInterceptor requestInterceptor;

    @Override
    public String handle(String json) {
        Request request = null;
        Response<Object> response = null;
        try {
            request = new RequestJsonDecoder().decode(json);
            if (this.requestInterceptor != null) {
                this.requestInterceptor.handle(request);
            }
            response = this.handle(request);
        }
        catch (InvalidTimestampException e) {
            this.logHandleException(request, e);
            response = Response.ofFailure(Response.Code.INVALID_TIMESTAMP, e.getMessage());
        }
        catch (AuthException e) {
            this.logHandleException(request, e);
            response = Response.ofFailure(Response.Code.FORBIDDEN, e.getMessage());
        }
        catch (Exception e) {
            this.logHandleException(request, e);
            response = Response.ofFailure(Response.Code.SERVER_ERROR, e.getMessage());
        }
        try {
            String resp = new JsonEncoder().encode(response);
            return resp;
        }
        catch (EncoderException e) {
            this.logHandleException(request, e);
            throw new RuntimeException(e);
        }
    }

    public void setRequestInterceptor(RequestInterceptor requestInterceptor) {
        this.requestInterceptor = requestInterceptor;
    }

    public abstract void logHandleException(Request var1, Exception var2);
}

