/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api;

import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.auth.api.AuthException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.auth.api.AuthUtil;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.Request;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.RequestException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.RequestInterceptorChain;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.Tuple;

public abstract class AuthInterceptor
extends RequestInterceptorChain {
    public static final String SIGN_DATA = "sd";
    public static final String SIGN_KEY = "sn";

    @Override
    public void doHandle(Request request) throws RequestException {
        boolean authResult;
        String sign = request.getHeader(SIGN_KEY);
        if (sign == null || sign.trim().length() == 0) {
            throw new AuthException("Sign must not be empty.");
        }
        Tuple<String, String> akAndSk = this.getAkAndSk(request);
        String secretKey = akAndSk.getR();
        if (secretKey == null || secretKey.length() == 0) {
            throw new AuthException("Illegal request. Cannot find secret key.");
        }
        String signData = request.getHeader(SIGN_DATA);
        if (signData == null) {
            signData = JSON.toJSONString(request.getParams(), SerializerFeature.MapSortField);
        }
        if (!(authResult = AuthUtil.auth(sign, secretKey, signData))) {
            throw new AuthException("Illegal request.");
        }
    }

    @Override
    public void doInvoke(Request request) throws RequestException {
        String sign;
        try {
            Tuple<String, String> akAndSk = this.getAkAndSk(request);
            String secretKey = akAndSk.getR();
            String signData = request.getHeader(SIGN_DATA);
            if (signData == null) {
                signData = JSON.toJSONString(request.getParams(), SerializerFeature.MapSortField);
            }
            sign = AuthUtil.sign(secretKey, signData);
        }
        catch (Exception e) {
            throw new AuthException(e);
        }
        request.addHeader(SIGN_KEY, sign);
    }

    public abstract Tuple<String, String> getAkAndSk(Request var1);
}

