/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl;

import com.alibaba.csp.ahas.shaded.com.taobao.diamond.identify.Base64;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.identify.CredentialService;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SpasAdapter {
    public static List<String> getSignHeaders(String resource, String secretKey) {
        ArrayList<String> header = new ArrayList<String>();
        String timeStamp = String.valueOf(System.currentTimeMillis());
        header.add("timeStamp");
        header.add(timeStamp);
        if (secretKey != null) {
            header.add("Spas-Signature");
            String signature = "";
            signature = StringUtils.isBlank(resource) ? SpasAdapter.signWithhmacSHA1Encrypt(timeStamp, secretKey) : SpasAdapter.signWithhmacSHA1Encrypt(resource + "+" + timeStamp, secretKey);
            header.add(signature);
        }
        return header;
    }

    public static List<String> getSignHeaders(List<String> paramValues, String secretKey) {
        if (null == paramValues) {
            return null;
        }
        HashMap<String, String> signMap = new HashMap<String, String>();
        Iterator<String> iter = paramValues.iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            if ("tenant".equals(key) || "group".equals(key)) {
                signMap.put(key, iter.next());
                continue;
            }
            iter.next();
        }
        String resource = "";
        resource = signMap.size() > 1 ? (String)signMap.get("tenant") + "+" + (String)signMap.get("group") : (!StringUtils.isBlank((String)signMap.get("group")) ? (String)signMap.get("group") : (String)signMap.get("tenant"));
        return SpasAdapter.getSignHeaders(resource, secretKey);
    }

    public static String getSk() {
        return CredentialService.getInstance().getCredential().getSecretKey();
    }

    public static String getAk() {
        return CredentialService.getInstance().getCredential().getAccessKey();
    }

    public static String signWithhmacSHA1Encrypt(String encryptText, String encryptKey) {
        try {
            byte[] data = encryptKey.getBytes("UTF-8");
            SecretKeySpec secretKey = new SecretKeySpec(data, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(secretKey);
            byte[] text = encryptText.getBytes("UTF-8");
            byte[] textFinal = mac.doFinal(text);
            return new String(Base64.encodeBase64(textFinal));
        }
        catch (Exception e) {
            throw new RuntimeException("signWithhmacSHA1Encrypt fail", e);
        }
    }
}

