/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.diamond.utils;

import java.util.concurrent.atomic.AtomicLong;

public class TimeoutUtils {
    private final AtomicLong totalTime = new AtomicLong(0L);
    private volatile long lastResetTime;
    private volatile boolean initialized = false;
    private long totalTimeout;
    private long invalidThreshold;

    public TimeoutUtils(long totalTimeout, long invalidThreshold) {
        this.totalTimeout = totalTimeout;
        this.invalidThreshold = invalidThreshold;
    }

    public synchronized void initLastResetTime() {
        if (this.initialized) {
            return;
        }
        this.lastResetTime = System.currentTimeMillis();
        this.initialized = true;
    }

    public void addTotalTime(long time) {
        this.totalTime.addAndGet(time);
    }

    public boolean isTimeout() {
        return this.totalTime.get() > this.totalTimeout;
    }

    public void resetTotalTime() {
        if (this.isTotalTimeExpired()) {
            this.totalTime.set(0L);
            this.lastResetTime = System.currentTimeMillis();
        }
    }

    public AtomicLong getTotalTime() {
        return this.totalTime;
    }

    private boolean isTotalTimeExpired() {
        return System.currentTimeMillis() - this.lastResetTime > this.invalidThreshold;
    }
}

