/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel;

import com.alibaba.csp.sentinel.AsyncEntry;
import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.CtEntry;
import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.Sph;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.context.NullContext;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slotchain.MethodResourceWrapper;
import com.alibaba.csp.sentinel.slotchain.ProcessorSlot;
import com.alibaba.csp.sentinel.slotchain.ProcessorSlotChain;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slotchain.SlotChainProvider;
import com.alibaba.csp.sentinel.slotchain.StringResourceWrapper;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class CtSph
implements Sph {
    private static final Object[] OBJECTS0 = new Object[0];
    private static volatile Map<String, ProcessorSlotChain> chainMap = new HashMap<String, ProcessorSlotChain>();
    private static final Object LOCK = new Object();

    private AsyncEntry asyncEntryWithNoChain(ResourceWrapper resourceWrapper, Context context) {
        AsyncEntry entry = new AsyncEntry(resourceWrapper, null, context);
        entry.initAsyncContext();
        entry.cleanCurrentEntryInLocal();
        return entry;
    }

    private AsyncEntry asyncEntryWithPriorityInternal(ResourceWrapper resourceWrapper, int batchCount, boolean prioritized, Object[] args, Map<String, Object> argMap) throws BlockException {
        Context context = ContextUtil.getContext();
        if (context instanceof NullContext) {
            return this.asyncEntryWithNoChain(resourceWrapper, context);
        }
        if (context == null) {
            context = InternalContextUtil.internalEnter("sentinel_default_context");
        }
        if (!Constants.ON) {
            return this.asyncEntryWithNoChain(resourceWrapper, context);
        }
        ProcessorSlot<Object> chain = this.lookProcessChain(resourceWrapper);
        if (chain == null) {
            return this.asyncEntryWithNoChain(resourceWrapper, context);
        }
        AsyncEntry asyncEntry = new AsyncEntry(resourceWrapper, chain, context, batchCount, argMap);
        try {
            chain.entry(context, resourceWrapper, null, batchCount, prioritized, args);
            asyncEntry.initAsyncContext();
            asyncEntry.cleanCurrentEntryInLocal();
        }
        catch (BlockException e1) {
            asyncEntry.exitForContext(context, batchCount, args);
            throw e1;
        }
        catch (Throwable e1) {
            RecordLog.warn("Sentinel unexpected exception in asyncEntryInternal", e1);
            asyncEntry.cleanCurrentEntryInLocal();
        }
        return asyncEntry;
    }

    private AsyncEntry asyncEntryInternal(ResourceWrapper resourceWrapper, int count, Object[] args, Map<String, Object> argMap) throws BlockException {
        return this.asyncEntryWithPriorityInternal(resourceWrapper, count, false, args, argMap);
    }

    private Entry entryWithPriority(ResourceWrapper resourceWrapper, int batchCount, boolean prioritized, Object[] args, Map<String, Object> argMap) throws BlockException {
        Context context = ContextUtil.getContext();
        if (context instanceof NullContext) {
            return new CtEntry(resourceWrapper, null, context);
        }
        if (context == null) {
            context = InternalContextUtil.internalEnter("sentinel_default_context");
        }
        if (!Constants.ON) {
            return new CtEntry(resourceWrapper, null, context);
        }
        ProcessorSlot<Object> chain = this.lookProcessChain(resourceWrapper);
        if (chain == null) {
            return new CtEntry(resourceWrapper, null, context);
        }
        CtEntry e = new CtEntry(resourceWrapper, chain, context, batchCount, argMap);
        try {
            chain.entry(context, resourceWrapper, null, batchCount, prioritized, args);
        }
        catch (BlockException e1) {
            ((Entry)e).exit(batchCount, args);
            throw e1;
        }
        catch (Throwable e1) {
            RecordLog.info("Sentinel unexpected exception", e1);
        }
        return e;
    }

    public Entry entry(ResourceWrapper resourceWrapper, int count, Object ... args) throws BlockException {
        return this.entryWithPriority(resourceWrapper, count, false, args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProcessorSlot<Object> lookProcessChain(ResourceWrapper resourceWrapper) {
        String resourceName = resourceWrapper.getName();
        ProcessorSlotChain chain = chainMap.get(resourceName);
        if (chain == null) {
            Object object = LOCK;
            synchronized (object) {
                chain = chainMap.get(resourceName);
                if (chain == null) {
                    if (chainMap.size() >= SentinelConfig.maxResourceAmount()) {
                        return null;
                    }
                    chain = SlotChainProvider.newSlotChain();
                    HashMap<String, ProcessorSlotChain> newMap = new HashMap<String, ProcessorSlotChain>(chainMap.size() + 1);
                    newMap.putAll(chainMap);
                    newMap.put(resourceName, chain);
                    chainMap = newMap;
                }
            }
        }
        return chain;
    }

    public static int entrySize() {
        return chainMap.size();
    }

    public static boolean resourceExists(String resource) {
        if (resource == null) {
            return false;
        }
        return chainMap.containsKey(resource);
    }

    static void resetChainMap() {
        chainMap.clear();
    }

    static Map<String, ProcessorSlotChain> getChainMap() {
        return chainMap;
    }

    @Override
    public Entry entry(String name) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, EntryType.OUT);
        return this.entry(resource, 1, OBJECTS0);
    }

    @Override
    public Entry entry(Method method) throws BlockException {
        MethodResourceWrapper resource = new MethodResourceWrapper(method, EntryType.OUT);
        return this.entry(resource, 1, OBJECTS0);
    }

    @Override
    public Entry entry(Method method, EntryType type) throws BlockException {
        MethodResourceWrapper resource = new MethodResourceWrapper(method, type);
        return this.entry(resource, 1, OBJECTS0);
    }

    @Override
    public Entry entry(String name, EntryType type) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, type);
        return this.entry(resource, 1, OBJECTS0);
    }

    @Override
    public Entry entry(Method method, EntryType type, int count) throws BlockException {
        MethodResourceWrapper resource = new MethodResourceWrapper(method, type);
        return this.entry(resource, count, OBJECTS0);
    }

    @Override
    public Entry entry(String name, EntryType type, int count) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, type);
        return this.entry(resource, count, OBJECTS0);
    }

    @Override
    public Entry entry(Method method, int count) throws BlockException {
        MethodResourceWrapper resource = new MethodResourceWrapper(method, EntryType.OUT);
        return this.entry(resource, count, OBJECTS0);
    }

    @Override
    public Entry entry(String name, int count) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, EntryType.OUT);
        return this.entry(resource, count, OBJECTS0);
    }

    @Override
    public Entry entry(Method method, EntryType type, int count, Object ... args) throws BlockException {
        MethodResourceWrapper resource = new MethodResourceWrapper(method, type);
        return this.entry(resource, count, args);
    }

    @Override
    public Entry entry(String name, EntryType type, int count, Object ... args) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, type);
        return this.entry(resource, count, args);
    }

    @Override
    public AsyncEntry asyncEntry(String name, EntryType trafficType, int batchCount, Object ... args) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, trafficType);
        return this.asyncEntryInternal(resource, batchCount, args, null);
    }

    @Override
    public AsyncEntry asyncEntry(String name, EntryType trafficType, int batchCount, Map<String, Object> argMap) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, trafficType);
        return this.asyncEntryInternal(resource, batchCount, null, argMap);
    }

    @Override
    public Entry entryWithPriority(String name, EntryType type, int count, boolean prioritized) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, type);
        return this.entryWithPriority(resource, count, prioritized, OBJECTS0, null);
    }

    @Override
    public Entry entryWithPriority(String name, EntryType type, int count, boolean prioritized, Object ... args) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, type);
        return this.entryWithPriority(resource, count, prioritized, args, null);
    }

    @Override
    public Entry entryWithType(String name, int resourceType, EntryType trafficType, int count, Object[] args) throws BlockException {
        return this.entryWithType(name, resourceType, trafficType, count, false, args);
    }

    @Override
    public Entry entryWithType(String name, int resourceType, EntryType trafficType, int batchCount, Map<String, Object> argMap) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, trafficType, resourceType);
        return this.entryWithPriority(resource, batchCount, false, null, argMap);
    }

    @Override
    public Entry entryWithType(String name, int resourceType, EntryType trafficType, int batchCount, boolean prioritized, Object[] args) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, trafficType, resourceType);
        return this.entryWithPriority(resource, batchCount, prioritized, args, null);
    }

    @Override
    public AsyncEntry asyncEntryWithType(String name, int resourceType, EntryType trafficType, int batchCount, boolean prioritized, Object[] args) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, trafficType, resourceType);
        return this.asyncEntryWithPriorityInternal(resource, batchCount, prioritized, args, null);
    }

    @Override
    public AsyncEntry asyncEntryWithType(String name, int resourceType, EntryType trafficType, int batchCount, boolean prioritized, Map<String, Object> argMap) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, trafficType, resourceType);
        return this.asyncEntryWithPriorityInternal(resource, batchCount, prioritized, null, argMap);
    }

    private static final class InternalContextUtil
    extends ContextUtil {
        private InternalContextUtil() {
        }

        static Context internalEnter(String name) {
            return InternalContextUtil.trueEnter(name, "");
        }

        static Context internalEnter(String name, String origin) {
            return InternalContextUtil.trueEnter(name, origin);
        }
    }
}

