/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel;

import com.alibaba.csp.sentinel.ErrorEntryFreeException;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.node.ClusterNode;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.node.Node;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.TimeUtil;
import com.alibaba.csp.sentinel.util.function.BiConsumer;
import java.util.Map;

public abstract class Entry
implements AutoCloseable {
    private static final Object[] OBJECTS0 = new Object[0];
    private final long createTimestamp;
    private long completeTimestamp;
    private Node curNode;
    private Node originNode;
    private final int batchCount;
    private final Map<String, Object> argMap;
    private Throwable error;
    private BlockException blockError;
    protected final ResourceWrapper resourceWrapper;

    public Entry(ResourceWrapper resourceWrapper, int batchCount) {
        this(resourceWrapper, batchCount, null);
    }

    public Entry(ResourceWrapper resourceWrapper, int batchCount, Map<String, Object> argMap) {
        this.resourceWrapper = resourceWrapper;
        this.createTimestamp = TimeUtil.currentTimeMillis();
        this.batchCount = batchCount;
        this.argMap = argMap;
    }

    public ResourceWrapper getResourceWrapper() {
        return this.resourceWrapper;
    }

    public void exit() throws ErrorEntryFreeException {
        this.exit(this.batchCount, OBJECTS0);
    }

    public void exit(int count) throws ErrorEntryFreeException {
        this.exit(count, OBJECTS0);
    }

    @Override
    public void close() {
        this.exit();
    }

    public abstract void exit(int var1, Object ... var2) throws ErrorEntryFreeException;

    protected abstract Entry trueExit(int var1, Object ... var2) throws ErrorEntryFreeException;

    public abstract Node getLastNode();

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public long getCompleteTimestamp() {
        return this.completeTimestamp;
    }

    public Entry setCompleteTimestamp(long completeTimestamp) {
        this.completeTimestamp = completeTimestamp;
        return this;
    }

    public Node getCurNode() {
        return this.curNode;
    }

    public ClusterNode getCurResourceNode() {
        if (this.curNode == null || !(this.curNode instanceof DefaultNode)) {
            return null;
        }
        return ((DefaultNode)this.curNode).getClusterNode();
    }

    public void setCurNode(Node node) {
        this.curNode = node;
    }

    public BlockException getBlockError() {
        return this.blockError;
    }

    public Entry setBlockError(BlockException blockError) {
        this.blockError = blockError;
        return this;
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public Node getOriginNode() {
        return this.originNode;
    }

    public void setOriginNode(Node originNode) {
        this.originNode = originNode;
    }

    public abstract void whenTerminate(BiConsumer<Context, Entry> var1);

    public int getBatchCount() {
        return this.batchCount;
    }

    public Map<String, Object> getArgMap() {
        return this.argMap;
    }
}

