/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.apache.dubbo;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.apache.dubbo.BaseSentinelDubboFilter;
import com.alibaba.csp.sentinel.adapter.apache.dubbo.SentinelDubboUtils;
import com.alibaba.csp.sentinel.adapter.apache.dubbo.config.DubboAdapterGlobalConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.support.RpcUtils;

@Activate(group={"consumer"})
public class SentinelDubboConsumerFilter
extends BaseSentinelDubboFilter {
    public SentinelDubboConsumerFilter() {
        RecordLog.info("Sentinel Apache Dubbo consumer filter initialized", new Object[0]);
    }

    @Override
    String getMethodName(Invoker invoker, Invocation invocation, String prefix) {
        return SentinelDubboUtils.getMethodResourceName(invoker, invocation, prefix);
    }

    @Override
    String getInterfaceName(Invoker invoker, String prefix) {
        return SentinelDubboUtils.getInterfaceName(invoker, prefix);
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        boolean asyncMode;
        boolean bl = asyncMode = RpcUtils.isReturnTypeFuture((Invocation)invocation) || RpcUtils.isAsync((URL)invoker.getUrl(), (Invocation)invocation);
        if (asyncMode && SentinelDubboUtils.isDubbo273OrAboveExists()) {
            return this.asyncInvoke(invoker, invocation);
        }
        return this.syncInvoke(invoker, invocation);
    }

    private Result syncInvoke(Invoker<?> invoker, Invocation invocation) {
        Entry interfaceEntry = null;
        Entry methodEntry = null;
        String prefix = DubboAdapterGlobalConfig.getDubboConsumerResNamePrefixKey();
        String interfaceResourceName = this.getInterfaceName(invoker, prefix);
        String methodResourceName = this.getMethodName(invoker, invocation, prefix);
        try {
            interfaceEntry = SphU.entry(interfaceResourceName, 2, EntryType.OUT);
            methodEntry = SphU.entry(methodResourceName, 2, EntryType.OUT, invocation.getArguments());
            Result result = invoker.invoke(invocation);
            if (result.hasException()) {
                Tracer.traceEntry(result.getException(), interfaceEntry);
                Tracer.traceEntry(result.getException(), methodEntry);
            }
            Result result2 = result;
            return result2;
        }
        catch (BlockException e) {
            String blockResource = interfaceEntry == null ? interfaceResourceName : methodResourceName;
            Result result = DubboAdapterGlobalConfig.getConsumerFallback().handle(invoker, invocation, e, blockResource);
            return result;
        }
        catch (RpcException e) {
            Tracer.traceEntry(e, interfaceEntry);
            Tracer.traceEntry(e, methodEntry);
            throw e;
        }
        finally {
            if (methodEntry != null) {
                methodEntry.exit(1, invocation.getArguments());
            }
            if (interfaceEntry != null) {
                interfaceEntry.exit();
            }
        }
    }

    private Result asyncInvoke(Invoker<?> invoker, Invocation invocation) {
        LinkedList<EntryHolder> queue = new LinkedList<EntryHolder>();
        String prefix = DubboAdapterGlobalConfig.getDubboConsumerResNamePrefixKey();
        String interfaceResourceName = this.getInterfaceName(invoker, prefix);
        String methodResourceName = this.getMethodName(invoker, invocation, prefix);
        try {
            queue.push(new EntryHolder(SphU.asyncEntry(interfaceResourceName, 2, EntryType.OUT), null));
            queue.push(new EntryHolder(SphU.asyncEntry(methodResourceName, 2, EntryType.OUT, 1, invocation.getArguments()), invocation.getArguments()));
            Result result = invoker.invoke(invocation);
            result.whenCompleteWithContext((r, throwable) -> {
                Throwable error = throwable;
                if (error == null) {
                    error = Optional.ofNullable(r).map(Result::getException).orElse(null);
                }
                while (!queue.isEmpty()) {
                    EntryHolder holder = (EntryHolder)queue.pop();
                    Tracer.traceEntry(error, holder.entry);
                    this.exitEntry(holder);
                }
            });
            return result;
        }
        catch (BlockException e) {
            String blockResource = "";
            if (queue.size() == 0) {
                blockResource = interfaceResourceName;
            } else if (queue.size() == 1) {
                blockResource = methodResourceName;
            }
            while (!queue.isEmpty()) {
                this.exitEntry((EntryHolder)queue.pop());
            }
            return DubboAdapterGlobalConfig.getConsumerFallback().handle(invoker, invocation, e, blockResource);
        }
    }

    private void exitEntry(EntryHolder holder) {
        if (holder.params != null) {
            holder.entry.exit(1, holder.params);
        } else {
            holder.entry.exit();
        }
    }

    static class EntryHolder {
        private final Entry entry;
        private final Object[] params;

        public EntryHolder(Entry entry, Object[] params) {
            this.entry = entry;
            this.params = params;
        }
    }
}

