/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.apache.dubbo;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.apache.dubbo.BaseSentinelDubboFilter;
import com.alibaba.csp.sentinel.adapter.apache.dubbo.SentinelDubboUtils;
import com.alibaba.csp.sentinel.adapter.apache.dubbo.config.DubboAdapterGlobalConfig;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.StringUtil;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"provider"})
public class SentinelDubboProviderFilter
extends BaseSentinelDubboFilter {
    public SentinelDubboProviderFilter() {
        RecordLog.info("Sentinel Apache Dubbo provider filter initialized", new Object[0]);
    }

    @Override
    String getMethodName(Invoker invoker, Invocation invocation, String prefix) {
        return SentinelDubboUtils.getMethodResourceName(invoker, invocation, prefix);
    }

    @Override
    String getInterfaceName(Invoker invoker, String prefix) {
        return SentinelDubboUtils.getInterfaceName(invoker, prefix);
    }

    private String resolveOrigin(Invoker<?> invoker, Invocation invocation) {
        try {
            String origin = "";
            if (SentinelDubboUtils.isDubbo273OrAboveExists()) {
                origin = RpcContext.getServerContext().getRemoteApplicationName();
            }
            if (!StringUtil.isEmpty(origin)) {
                return origin;
            }
            origin = DubboAdapterGlobalConfig.getOriginParser().parse(invoker, invocation);
            if (!StringUtil.isBlank(origin)) {
                return origin;
            }
            return "";
        }
        catch (Throwable ex) {
            return "";
        }
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String origin = this.resolveOrigin(invoker, invocation);
        if (null == origin) {
            origin = "";
        }
        Entry interfaceEntry = null;
        Entry methodEntry = null;
        String prefix = DubboAdapterGlobalConfig.getDubboProviderResNamePrefixKey();
        String interfaceResourceName = this.getInterfaceName(invoker, prefix);
        String methodResourceName = this.getMethodName(invoker, invocation, prefix);
        try {
            ContextUtil.enter(methodResourceName, origin);
            interfaceEntry = SphU.entry(interfaceResourceName, 2, EntryType.OUT);
            methodEntry = SphU.entry(methodResourceName, 2, EntryType.IN, invocation.getArguments());
            Result result = invoker.invoke(invocation);
            if (result.hasException()) {
                Tracer.traceEntry(result.getException(), interfaceEntry);
                Tracer.traceEntry(result.getException(), methodEntry);
            }
            Result result2 = result;
            return result2;
        }
        catch (BlockException e) {
            String blockResource = interfaceEntry == null ? interfaceResourceName : methodResourceName;
            Result result = DubboAdapterGlobalConfig.getProviderFallback().handle(invoker, invocation, e, blockResource);
            return result;
        }
        catch (RpcException e) {
            Tracer.traceEntry(e, interfaceEntry);
            Tracer.traceEntry(e, methodEntry);
            throw e;
        }
        finally {
            if (methodEntry != null) {
                methodEntry.exit(1, invocation.getArguments());
            }
            if (interfaceEntry != null) {
                interfaceEntry.exit();
            }
            ContextUtil.exit();
        }
    }
}

