/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.apache.dubbo;

import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Arrays;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;

public final class SentinelDubboUtils {
    public static final String SENTINEL_DUBBO_APPLICATION_KEY = "dubboApplication";
    private static boolean dubbo273OrAboveExists;

    public static String getApplication(Invocation invocation, String defaultValue) {
        if (invocation == null || invocation.getAttachments() == null) {
            throw new IllegalArgumentException("Bad invocation instance");
        }
        return invocation.getAttachment(SENTINEL_DUBBO_APPLICATION_KEY, defaultValue);
    }

    public static String getMethodResourceName(Invoker<?> invoker, Invocation invocation) {
        StringBuilder buf = new StringBuilder(64);
        String interfaceResource = SentinelDubboUtils.getInterfaceName(invoker);
        buf.append(interfaceResource).append(":").append(invocation.getMethodName()).append("(");
        boolean isFirst = true;
        for (Class clazz : invocation.getParameterTypes()) {
            if (!isFirst) {
                buf.append(",");
            }
            buf.append(clazz.getName());
            isFirst = false;
        }
        buf.append(")");
        return buf.toString();
    }

    public static String getMethodResourceName(Invoker<?> invoker, Invocation invocation, String prefix) {
        if (StringUtil.isNotBlank(prefix)) {
            return new StringBuilder(64).append(prefix).append(SentinelDubboUtils.getMethodResourceName(invoker, invocation)).toString();
        }
        return SentinelDubboUtils.getMethodResourceName(invoker, invocation);
    }

    public static String getInterfaceName(Invoker invoker) {
        return invoker.getInterface().getName();
    }

    public static String getInterfaceName(Invoker<?> invoker, String prefix) {
        if (StringUtil.isNotBlank(prefix)) {
            return new StringBuilder(64).append(prefix).append(SentinelDubboUtils.getInterfaceName(invoker)).toString();
        }
        return SentinelDubboUtils.getInterfaceName(invoker);
    }

    public static boolean isDubbo273OrAboveExists() {
        return dubbo273OrAboveExists;
    }

    private SentinelDubboUtils() {
    }

    static {
        try {
            boolean supportAsync;
            Class<?> clazz = Class.forName("org.apache.dubbo.rpc.Result");
            dubbo273OrAboveExists = supportAsync = Arrays.stream(clazz.getMethods()).anyMatch(e -> "whenCompleteWithContext".equals(e.getName()));
        }
        catch (Throwable t) {
            dubbo273OrAboveExists = false;
        }
    }
}

