/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.apache.dubbo.fallback;

import com.alibaba.csp.sentinel.adapter.apache.dubbo.SentinelDubboUtils;
import com.alibaba.csp.sentinel.adapter.apache.dubbo.fallback.DubboFallback;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfig;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackUtils;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.function.Tuple2;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;

public class DefaultDubboFallback
implements DubboFallback {
    @Override
    public Result handle(Invoker<?> invoker, Invocation invocation, BlockException ex, String resourceName) {
        if (!SentinelDubboUtils.isDubbo273OrAboveExists()) {
            throw ex.toRuntimeException();
        }
        try {
            Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior> fallbackPair = BlockFallbackUtils.getRpcFallbackInstance(resourceName, ex);
            if (fallbackPair == null) {
                return AsyncRpcResult.newDefaultAsyncResult((Throwable)ex.toRuntimeException(), (Invocation)invocation);
            }
            if (((BlockFallbackConfig.RpcBlockFallbackBehavior)fallbackPair.r2).getRpcFallbackMode() == 0) {
                return AsyncRpcResult.newDefaultAsyncResult(fallbackPair.r1, (Invocation)invocation);
            }
            return AsyncRpcResult.newDefaultAsyncResult((Throwable)((Throwable)fallbackPair.r1), (Invocation)invocation);
        }
        catch (Throwable t) {
            RecordLog.warn("[DubboReflectCustomException] Custom rpc fallback error", t);
            return AsyncRpcResult.newDefaultAsyncResult((Throwable)ex.toRuntimeException(), (Invocation)invocation);
        }
    }
}

